/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.net;

import java.util.Collections;
import java.util.List;
import org.instancio.Random;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.util.CollectionUtils;

abstract class AbstractURIGenerator<T>
extends AbstractGenerator<T> {
    private static final int DEFAULT_PORT = -1;
    private static final int WITH_RANDOM_PORT = -2;
    private static final int PORT_MIN = 1;
    private static final int PORT_MAX = 65535;
    private static final int HOST_MIN_LENGTH = 3;
    private static final int HOST_MAX_LENGTH = 12;
    private static final String DEFAULT_SCHEME = "http";
    private List<String> schemes = Collections.emptyList();
    private Generator<String> hostGenerator;
    private int port = -1;
    private Generator<String> pathGenerator;

    AbstractURIGenerator(GeneratorContext context) {
        super(context);
    }

    final void withScheme(String ... schemes) {
        this.schemes = CollectionUtils.asUnmodifiableList(schemes);
    }

    final void withHost(Generator<String> hostGenerator) {
        this.hostGenerator = hostGenerator;
    }

    final void withPath(Generator<String> pathGenerator) {
        this.pathGenerator = pathGenerator;
    }

    final void withPort(int port) {
        this.port = port;
    }

    final void withRandomPort() {
        this.withPort(-2);
    }

    final String getHost(Random random) {
        return this.hostGenerator == null ? random.lowerCaseAlphabetic(random.intRange(3, 12)) : this.hostGenerator.generate(random);
    }

    final String getPath(Random random, String defaultValue) {
        return this.pathGenerator == null ? defaultValue : this.pathGenerator.generate(random);
    }

    final String getScheme(Random random) {
        return this.schemes.isEmpty() ? DEFAULT_SCHEME : random.oneOf(this.schemes);
    }

    final int getPort(Random random) {
        return this.port == -2 ? random.intRange(1, 65535) : this.port;
    }
}

