/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.selectors;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.instancio.GroupableSelector;
import org.instancio.Scope;
import org.instancio.Selector;
import org.instancio.TargetSelector;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.Flattener;
import org.instancio.internal.selectors.PrimitiveAndWrapperSelectorImpl;
import org.instancio.internal.selectors.ScopeImpl;
import org.instancio.internal.selectors.UnusedSelectorDescription;
import org.instancio.internal.util.Format;
import org.instancio.internal.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SelectorImpl
implements Selector,
GroupableSelector,
Flattener<TargetSelector>,
UnusedSelectorDescription {
    private static final SelectorImpl ROOT_SELECTOR = SelectorImpl.builder().depth(0).build();
    private final Class<?> targetClass;
    private final String fieldName;
    private final List<Scope> scopes;
    private final Selector parent;
    private final Throwable stackTraceHolder;
    private final Integer depth;
    private int hash;

    private SelectorImpl(@Nullable Class<?> targetClass, @Nullable String fieldName, @NotNull List<Scope> scopes, @Nullable Selector parent, @NotNull Throwable stackTraceHolder, @Nullable Integer depth) {
        this.targetClass = targetClass;
        this.fieldName = fieldName;
        this.scopes = Collections.unmodifiableList(scopes);
        this.parent = parent;
        this.stackTraceHolder = stackTraceHolder;
        this.depth = depth;
    }

    private SelectorImpl(Builder builder) {
        this(builder.targetClass, builder.fieldName, ObjectUtils.defaultIfNull(builder.scopes, Collections.emptyList()), builder.parent, ObjectUtils.defaultIfNull(builder.stackTraceHolder, Throwable::new), builder.depth);
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.targetClass = this.targetClass;
        builder.fieldName = this.fieldName;
        builder.scopes = this.scopes;
        builder.parent = this.parent;
        builder.stackTraceHolder = this.stackTraceHolder;
        builder.depth = this.depth;
        return builder;
    }

    public static SelectorImpl getRootSelector() {
        return ROOT_SELECTOR;
    }

    public boolean isRoot() {
        return this == ROOT_SELECTOR;
    }

    public Throwable getStackTraceHolder() {
        return this.stackTraceHolder;
    }

    @Override
    public Selector atDepth(int depth) {
        return this.toBuilder().depth(ApiValidator.validateDepth(depth)).build();
    }

    @Override
    public String getDescription() {
        return String.format("%s%n    at %s", this, Format.firstNonInstancioStackTraceLine(this.stackTraceHolder));
    }

    @Override
    public Selector within(Scope ... scopes) {
        return this.toBuilder().scopes(Arrays.asList(scopes)).build();
    }

    @Override
    public Scope toScope() {
        return new ScopeImpl(this.targetClass, this.fieldName, this.depth);
    }

    @Override
    public List<TargetSelector> flatten() {
        return Collections.singletonList(this);
    }

    public Selector getParent() {
        return this.parent;
    }

    public List<Scope> getScopes() {
        return this.scopes;
    }

    public boolean isFieldSelector() {
        return this.fieldName != null;
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Integer getDepth() {
        return this.depth;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SelectorImpl)) {
            return false;
        }
        SelectorImpl that = (SelectorImpl)o;
        return Objects.equals(this.targetClass, that.targetClass) && Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.scopes, that.scopes) && Objects.equals(this.depth, that.depth);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.computeHashCode();
        }
        return this.hash;
    }

    private int computeHashCode() {
        int result = this.targetClass == null ? 0 : this.targetClass.hashCode();
        result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
        result = 31 * result + this.scopes.hashCode();
        result = 31 * result + (this.depth == null ? 0 : this.depth.hashCode());
        return result;
    }

    public String toString() {
        if (this.isRoot()) {
            return "root()";
        }
        StringBuilder sb = new StringBuilder();
        if (this.parent instanceof PrimitiveAndWrapperSelectorImpl) {
            sb.append(this.parent);
        } else {
            sb.append(this.isFieldSelector() ? "field(" : "all(");
            if (this.targetClass != null) {
                sb.append(this.targetClass.getSimpleName());
            }
            if (this.fieldName != null) {
                if (this.targetClass != null) {
                    sb.append(", ");
                }
                sb.append('\"').append(this.fieldName).append('\"');
            }
            sb.append(')');
            if (this.depth != null) {
                sb.append(".atDepth(").append(this.depth).append(')');
            } else if (!this.scopes.isEmpty()) {
                sb.append(", ").append(Format.formatScopes(this.scopes));
            }
        }
        return sb.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Class<?> targetClass;
        private String fieldName;
        private List<Scope> scopes;
        private Selector parent;
        private Throwable stackTraceHolder;
        private Integer depth;

        private Builder() {
        }

        public Builder targetClass(Class<?> targetClass) {
            this.targetClass = targetClass;
            return this;
        }

        public Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Builder scopes(List<Scope> scopes) {
            this.scopes = scopes;
            return this;
        }

        public Builder parent(Selector parent) {
            this.parent = parent;
            return this;
        }

        public Builder stackTraceHolder(Throwable stackTraceHolder) {
            this.stackTraceHolder = stackTraceHolder;
            return this;
        }

        public Builder depth(Integer depth) {
            this.depth = depth;
            return this;
        }

        public SelectorImpl build() {
            return new SelectorImpl(this);
        }
    }
}

