/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.annotation;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.GeneratorSpec;
import org.instancio.internal.GeneratorSpecProcessor;
import org.instancio.internal.annotation.AbstractAnnotationConsumer;
import org.instancio.internal.annotation.AnnotationConsumer;
import org.instancio.internal.annotation.AnnotationExtractor;
import org.instancio.internal.annotation.AnnotationMap;
import org.instancio.internal.annotation.HibernateBeanValidationAnnotationConsumer;
import org.instancio.internal.annotation.JakartaBeanValidationAnnotationConsumer;
import org.instancio.internal.annotation.JakartaPersistenceAnnotationConsumer;
import org.instancio.internal.annotation.JavaxBeanValidationAnnotationConsumer;
import org.instancio.internal.annotation.JavaxPersistenceAnnotationConsumer;
import org.instancio.internal.annotation.NoopGeneratorSpecProcessor;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.util.ReflectionUtils;
import org.instancio.settings.Keys;
import org.instancio.settings.Settings;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnnotationGeneratorSpecProcessor
implements GeneratorSpecProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationGeneratorSpecProcessor.class);
    private static final String JAVAX_PERSISTENCE_CLASS = "javax.persistence.Column";
    private static final String JAKARTA_PERSISTENCE_CLASS = "jakarta.persistence.Column";
    private static final String JAVAX_VALIDATOR_CLASS = "javax.validation.Validation";
    private static final String JAKARTA_VALIDATOR_CLASS = "jakarta.validation.Validation";
    private static final String HIBERNATE_VALIDATOR_CLASS = "org.hibernate.validator.HibernateValidator";
    private final List<AnnotationConsumer> annotationConsumers;
    private final AnnotationExtractor annotationExtractor;

    private AnnotationGeneratorSpecProcessor(ModelContext<?> context, List<AnnotationConsumer> annotationConsumers) {
        this.annotationConsumers = annotationConsumers;
        this.annotationExtractor = new AnnotationExtractor(context);
    }

    public static GeneratorSpecProcessor create(ModelContext<?> context) {
        List<AnnotationConsumer> consumers = AnnotationGeneratorSpecProcessor.getAnnotationConsumers(context);
        return consumers.isEmpty() ? new NoopGeneratorSpecProcessor() : new AnnotationGeneratorSpecProcessor(context, consumers);
    }

    @Override
    public void process(@NotNull GeneratorSpec<?> spec, @NotNull InternalNode node) {
        Annotation[] annotations = this.annotationExtractor.getAnnotations(node);
        if (annotations.length == 0) {
            return;
        }
        Class<?> targetClass = node.getTargetClass();
        AnnotationMap annotationMap = new AnnotationMap(annotations);
        block0: for (AnnotationConsumer provider : this.annotationConsumers) {
            for (Annotation annotation : annotations) {
                if (!provider.isPrimary(annotation.annotationType())) continue;
                annotationMap.setPrimary(annotation);
                provider.consumeAnnotations(annotationMap, spec, targetClass);
                continue block0;
            }
        }
        for (AnnotationConsumer provider : this.annotationConsumers) {
            provider.consumeAnnotations(annotationMap, spec, targetClass);
        }
    }

    private static List<AnnotationConsumer> getAnnotationConsumers(ModelContext<?> modelContext) {
        Settings settings = modelContext.getSettings();
        GeneratorContext generatorContext = new GeneratorContext(settings, modelContext.getRandom());
        boolean jpaEnabled = settings.get(Keys.JPA_ENABLED);
        boolean beanValidationEnabled = settings.get(Keys.BEAN_VALIDATION_ENABLED);
        LOG.trace("Keys.BEAN_VALIDATION_ENABLED={}, Keys.JPA_ENABLED={}", (Object)beanValidationEnabled, (Object)jpaEnabled);
        ArrayList<AbstractAnnotationConsumer> result = new ArrayList<AbstractAnnotationConsumer>();
        if (jpaEnabled) {
            if (ReflectionUtils.loadClass(JAVAX_PERSISTENCE_CLASS) != null) {
                result.add(new JavaxPersistenceAnnotationConsumer(generatorContext));
            }
            if (ReflectionUtils.loadClass(JAKARTA_PERSISTENCE_CLASS) != null) {
                result.add(new JakartaPersistenceAnnotationConsumer(generatorContext));
            }
        }
        if (beanValidationEnabled) {
            if (ReflectionUtils.loadClass(HIBERNATE_VALIDATOR_CLASS) != null) {
                result.add(new HibernateBeanValidationAnnotationConsumer(generatorContext));
            }
            if (ReflectionUtils.loadClass(JAKARTA_VALIDATOR_CLASS) != null) {
                result.add(new JakartaBeanValidationAnnotationConsumer(generatorContext));
            }
            if (ReflectionUtils.loadClass(JAVAX_VALIDATOR_CLASS) != null) {
                result.add(new JavaxBeanValidationAnnotationConsumer(generatorContext));
            }
        }
        return Collections.unmodifiableList(result);
    }
}

