/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.assignment;

import java.util.Set;
import org.instancio.TargetSelector;
import org.instancio.internal.DelayedNode;
import org.instancio.internal.DelayedNodeQueue;
import org.instancio.internal.assignment.InternalAssignment;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.util.Constants;
import org.instancio.internal.util.Format;

public final class AssignmentErrorUtil {
    private AssignmentErrorUtil() {
    }

    public static String getUnresolvedAssignmentErrorMessage(Set<InternalAssignment> unresolvedAssignments, DelayedNodeQueue delayedNodeQueue) {
        StringBuilder sb = new StringBuilder(2048).append("unresolved assignment expression").append(Constants.NL).append(Constants.NL).append("The following assignments could not be applied:").append(Constants.NL).append(Constants.NL);
        for (InternalAssignment assignment : unresolvedAssignments) {
            sb.append(" -> from [").append(assignment.getOrigin()).append("] to [").append(assignment.getDestination()).append(']').append(Constants.NL);
        }
        sb.append(Constants.NL).append("As a result, the following targets could not be assigned a value:").append(Constants.NL).append(Constants.NL);
        delayedNodeQueue.stream().map(DelayedNode::getNode).distinct().forEach(node -> sb.append(" -> ").append(node.toDisplayString()).append(" (depth=").append(node.getDepth()).append(')').append(Constants.NL));
        sb.append(Constants.NL).append("Possible causes:").append(Constants.NL).append(Constants.NL).append(" -> The assignments form a cycle, for example:").append(Constants.NL).append(Constants.NL).append("    Pojo pojo = Instancio.of(Pojo.class)").append(Constants.NL).append("        .assign(Assign.valueOf(Pojo::getFoo).to(Pojo::getBar))").append(Constants.NL).append("        .assign(Assign.valueOf(Pojo::getBar).to(Pojo::getFoo))").append(Constants.NL).append("        .create();").append(Constants.NL).append(Constants.NL).append(" -> Part of the assignment expression is ignored using the ignore() method:").append(Constants.NL).append(Constants.NL).append("    Person person = Instancio.of(Person.class)").append(Constants.NL).append("        .ignore(field(Person::getGender)) // ignored!").append(Constants.NL).append("        .assign(Assign.given(field(Person::getGender), field(Person::getName))").append(Constants.NL).append("                .set(When.is(Gender.FEMALE), \"Fiona\")").append(Constants.NL).append("                .set(When.is(Gender.MALE), \"Michael\"))").append(Constants.NL).append("        .create();").append(Constants.NL);
        return sb.toString();
    }

    public static String getAmbiguousErrorMessage(TargetSelector selector, InternalNode matchingNode1, InternalNode matchingNode2) {
        StringBuilder sb = new StringBuilder(2048).append("ambiguous assignment expression").append(Constants.NL).append(Constants.NL).append(" -> The origin selector '").append(selector).append("' matches multiple values.").append(Constants.NL).append("    It's not clear which of these values should be used:").append(Constants.NL).append(Constants.NL).append(" -> Match 1: ").append(matchingNode1.toDisplayString()).append(Constants.NL).append(Constants.NL).append(Format.nodePathToRoot(matchingNode1, "    ")).append(Constants.NL).append(Constants.NL).append(" -> Match 2: ").append(matchingNode2.toDisplayString()).append(Constants.NL).append(Constants.NL).append(Format.nodePathToRoot(matchingNode2, "    ")).append(Constants.NL).append(Constants.NL).append("Format: <depth:class: field>").append(Constants.NL).append(Constants.NL).append("There could be more matches. Evaluation stopped after the second match.").append(Constants.NL).append("To print the node hierarchy, run Instancio in verbose() mode:").append(Constants.NL).append(Constants.NL).append("  Instancio.of(Example.class)").append(Constants.NL).append("      // snip ...").append(Constants.NL).append("      .verbose()").append(Constants.NL).append("      .create();").append(Constants.NL).append(Constants.NL).append("To resolve the error, consider narrowing down the origin selector").append(Constants.NL).append("so that it matches only one target. This can be done using:").append(Constants.NL).append(Constants.NL).append(" -> Scopes").append(Constants.NL).append("    https://www.instancio.org/user-guide/#selector-scopes").append(Constants.NL).append(Constants.NL).append(" -> Depth").append(Constants.NL).append("    https://www.instancio.org/user-guide/#selector-depth");
        return sb.toString();
    }
}

