/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.context;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.instancio.GeneratorSpecProvider;
import org.instancio.TargetSelector;
import org.instancio.generator.AfterGenerate;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.generators.Generators;
import org.instancio.internal.Flattener;
import org.instancio.internal.context.SelectorMap;
import org.instancio.internal.context.SelectorMapImpl;
import org.instancio.internal.generator.InternalGeneratorHint;
import org.instancio.internal.generator.misc.GeneratorDecorator;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.settings.Keys;
import org.jetbrains.annotations.NotNull;

class GeneratorSelectorMap {
    private final GeneratorContext context;
    private final AfterGenerate defaultAfterGenerate;
    private final Map<TargetSelector, Generator<?>> generatorSelectors;
    private final Map<TargetSelector, GeneratorSpecProvider<?>> generatorSpecSelectors;
    private final SelectorMap<Generator<?>> selectorMap;
    private final Map<TargetSelector, Class<?>> generatorSubtypeMap = new LinkedHashMap();

    GeneratorSelectorMap(@NotNull GeneratorContext context, @NotNull Map<TargetSelector, Generator<?>> generatorSelectors, @NotNull Map<TargetSelector, GeneratorSpecProvider<?>> generatorSpecSelectors) {
        this.context = context;
        this.defaultAfterGenerate = context.getSettings().get(Keys.AFTER_GENERATE_HINT);
        this.generatorSelectors = Collections.unmodifiableMap(generatorSelectors);
        this.generatorSpecSelectors = Collections.unmodifiableMap(generatorSpecSelectors);
        this.selectorMap = generatorSelectors.isEmpty() && generatorSpecSelectors.isEmpty() ? SelectorMapImpl.emptyMap() : new SelectorMapImpl();
        this.putAllGeneratorSpecs(generatorSpecSelectors);
        this.putAllGenerators(generatorSelectors);
    }

    private void putAllGeneratorSpecs(Map<TargetSelector, GeneratorSpecProvider<?>> specs) {
        Generators generators = new Generators(this.context);
        for (Map.Entry<TargetSelector, GeneratorSpecProvider<?>> entry : specs.entrySet()) {
            TargetSelector targetSelector = entry.getKey();
            GeneratorSpecProvider<?> genFn = entry.getValue();
            for (TargetSelector selector : ((Flattener)((Object)targetSelector)).flatten()) {
                Generator generator = (Generator)genFn.getSpec(generators);
                this.putGenerator(selector, generator);
            }
        }
    }

    private void putAllGenerators(Map<TargetSelector, Generator<?>> generatorMap) {
        for (Map.Entry<TargetSelector, Generator<?>> entry : generatorMap.entrySet()) {
            TargetSelector targetSelector = entry.getKey();
            Generator<?> generator = entry.getValue();
            for (TargetSelector selector : ((Flattener)((Object)targetSelector)).flatten()) {
                this.putGenerator(selector, generator);
            }
        }
    }

    private void putGenerator(TargetSelector targetSelector, Generator<?> g) {
        g.init(this.context);
        Generator<?> generator = GeneratorDecorator.decorateIfNullAfterGenerate(g, this.defaultAfterGenerate);
        this.selectorMap.put(targetSelector, generator);
        InternalGeneratorHint internalHint = generator.hints().get(InternalGeneratorHint.class);
        Optional.ofNullable(internalHint).map(InternalGeneratorHint::targetClass).ifPresent(klass -> this.generatorSubtypeMap.put(targetSelector, (Class<?>)klass));
    }

    SelectorMap<Generator<?>> getSelectorMap() {
        return this.selectorMap;
    }

    Map<TargetSelector, Generator<?>> getGeneratorSelectors() {
        return this.generatorSelectors;
    }

    Map<TargetSelector, GeneratorSpecProvider<?>> getGeneratorSpecSelectors() {
        return this.generatorSpecSelectors;
    }

    Map<TargetSelector, Class<?>> getGeneratorSubtypeMap() {
        return Collections.unmodifiableMap(this.generatorSubtypeMap);
    }

    Optional<Generator<?>> getGenerator(InternalNode node) {
        return this.selectorMap.getValue(node);
    }
}

