/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.context;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.instancio.TargetSelector;
import org.instancio.internal.Flattener;
import org.instancio.internal.context.SelectorMap;
import org.instancio.internal.context.SelectorMapImpl;
import org.instancio.internal.nodes.InternalNode;
import org.jetbrains.annotations.NotNull;

final class TargetSelectorSelectorMap {
    private final SelectorMap<List<TargetSelector>> selectorMap;

    TargetSelectorSelectorMap(@NotNull Map<TargetSelector, List<TargetSelector>> targetSelectors) {
        this.selectorMap = targetSelectors.isEmpty() ? SelectorMapImpl.emptyMap() : new SelectorMapImpl();
        this.putAll(targetSelectors);
    }

    private void putAll(Map<TargetSelector, List<TargetSelector>> map) {
        for (Map.Entry<TargetSelector, List<TargetSelector>> entry : map.entrySet()) {
            TargetSelector targetSelector = entry.getKey();
            List<TargetSelector> assignments = entry.getValue();
            for (TargetSelector selector : ((Flattener)((Object)targetSelector)).flatten()) {
                this.selectorMap.put(selector, assignments);
            }
        }
    }

    SelectorMap<List<TargetSelector>> getSelectorMap() {
        return this.selectorMap;
    }

    List<TargetSelector> getTargetSelector(InternalNode node) {
        return this.selectorMap.getValue(node).orElse(Collections.emptyList());
    }
}

