/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.nodes.resolvers;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.instancio.internal.nodes.NodeKind;
import org.instancio.internal.nodes.NodeKindResolver;
import org.instancio.internal.spi.InternalContainerFactoryProvider;

class NodeKindContainerResolver
implements NodeKindResolver {
    private final List<InternalContainerFactoryProvider> containerFactories;

    NodeKindContainerResolver(List<InternalContainerFactoryProvider> containerFactories) {
        this.containerFactories = containerFactories;
    }

    @Override
    public Optional<NodeKind> resolve(Class<?> targetClass) {
        if (targetClass == Optional.class || targetClass == EnumSet.class || Map.Entry.class.isAssignableFrom(targetClass) || this.isSpiDefinedContainer(targetClass)) {
            return Optional.of(NodeKind.CONTAINER);
        }
        return Optional.empty();
    }

    private boolean isSpiDefinedContainer(Class<?> targetClass) {
        for (InternalContainerFactoryProvider p : this.containerFactories) {
            if (!p.isContainer(targetClass)) continue;
            return true;
        }
        return false;
    }
}

