/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.util;

import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringUtils {
    public static boolean isEmpty(@Nullable String s) {
        return s == null || "".equals(s);
    }

    public static boolean isBlank(@Nullable String s) {
        return s == null || "".equals(s.trim());
    }

    @NotNull
    public static String trimToEmpty(@Nullable String s) {
        return s == null ? "" : s.trim();
    }

    @Nullable
    public static String singleQuote(@Nullable String s) {
        return s == null ? null : "'" + s + "'";
    }

    public static String repeat(String s, int times) {
        if (times < 0) {
            throw new IllegalArgumentException("Number of times must be positive: " + times);
        }
        StringBuilder sb = new StringBuilder(s.length() * times);
        for (int i = 0; i < times; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static boolean startsWithAny(@Nullable String s, String ... prefixes) {
        if (s == null || prefixes.length == 0) {
            return false;
        }
        for (String prefix : prefixes) {
            if (!s.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static String concatNonNull(String ... values) {
        StringBuilder sb = new StringBuilder();
        if (values != null) {
            for (String val : values) {
                if (val == null) continue;
                sb.append(val);
            }
        }
        return sb.toString();
    }

    public static String capitalise(@Nullable String s) {
        if (s == null || s.equals("")) {
            return s;
        }
        String first = s.substring(0, 1).toUpperCase(Locale.getDefault());
        return s.length() == 1 ? first : first + s.substring(1);
    }

    public static <E extends Enum<E>> String enumToString(E val) {
        return val.getClass().getSimpleName() + "." + val.name();
    }

    public static String quoteToString(Object value) {
        if (value == null) {
            return null;
        }
        String str = value.toString();
        if (value instanceof String) {
            return '\"' + str + '\"';
        }
        return str;
    }

    private StringUtils() {
    }
}

