/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.util;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public final class Verify {
    public static <T> T notNull(@Nullable T object, String message, Object ... values) {
        return Objects.requireNonNull(object, () -> String.format(message, values));
    }

    public static <T> T[] notEmpty(@Nullable T[] array, String message, Object ... values) {
        Verify.isTrue(array != null && array.length > 0, message, values);
        return array;
    }

    public static <T> Collection<T> notEmpty(@Nullable Collection<T> collection, String message, Object ... values) {
        Verify.isTrue(collection != null && !collection.isEmpty(), message, values);
        return collection;
    }

    public static void closedRange(long min, long max) {
        if (min > max) {
            throw new IllegalArgumentException(String.format("Lower must be less than upper: %s, %s", min, max));
        }
    }

    public static void isTrue(boolean condition, String message, Object ... values) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(message, values));
        }
    }

    public static void isFalse(boolean condition, String message, Object ... values) {
        if (condition) {
            throw new IllegalArgumentException(String.format(message, values));
        }
    }

    public static void state(boolean condition, String message, Object ... values) {
        if (!condition) {
            throw new IllegalStateException(String.format(message, values));
        }
    }

    public static void isNotArrayCollectionOrMap(Class<?> klass) {
        if (klass.isArray() || Collection.class.isAssignableFrom(klass) || Map.class.isAssignableFrom(klass)) {
            throw new IllegalArgumentException("Unexpected: " + klass);
        }
    }

    private Verify() {
    }
}

