/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.context;

import java.util.Collection;
import org.instancio.TargetSelector;
import org.instancio.generator.Generator;
import org.instancio.internal.context.SelectorMap;
import org.instancio.internal.generator.misc.EmitGenerator;
import org.instancio.internal.selectors.UnusedSelectorDescription;
import org.instancio.internal.util.Constants;
import org.instancio.internal.util.Fail;

class UnusedEmitItemsReporter {
    private final SelectorMap<Generator<?>> selectorMap;

    UnusedEmitItemsReporter(SelectorMap<Generator<?>> selectorMap) {
        this.selectorMap = selectorMap;
    }

    void report() {
        this.selectorMap.forEach((selector, generator) -> {
            EmitGenerator g;
            if (generator instanceof EmitGenerator && !(g = (EmitGenerator)generator).isIgnoreUnused() && g.hasMore()) {
                throw Fail.withUsageError(UnusedEmitItemsReporter.buildUnusedItemsErrorMessage(selector, g.getItems()), new Object[0]);
            }
        });
    }

    private static String buildUnusedItemsErrorMessage(TargetSelector selector, Collection<?> items) {
        return new StringBuilder(256).append("not all the items provided via the 'emit()' method have been consumed").append(Constants.NL).append(Constants.NL).append("The following items are still remaining:").append(Constants.NL).append(Constants.NL).append(" -> ").append(((UnusedSelectorDescription)((Object)selector)).getDescription()).append(Constants.NL).append("    Remaining items: ").append(items).append(Constants.NL).append(Constants.NL).append("To resolve this error:").append(Constants.NL).append(Constants.NL).append(" -> Modify object creation to ensure all items are consumed.").append(Constants.NL).append("    For example, at least 7 elements are requied to consume the status values:").append(Constants.NL).append(Constants.NL).append("    List<Order> orders = Instancio.ofList(Order.class)").append(Constants.NL).append("        .size(7) // 5 shipped + 2 cancelled").append(Constants.NL).append("        .generate(field(Order::getStatus), gen -> gen.emit()").append(Constants.NL).append("               .items(OrderStatus.SHIPPED, 5)").append(Constants.NL).append("               .items(OrderStatus.CANCELLED, 2))").append(Constants.NL).append("        .create();").append(Constants.NL).append(Constants.NL).append(" -> When using a composite selector such as 'allInts()'").append(Constants.NL).append("    each member gets its own copy of the items, for example:").append(Constants.NL).append(Constants.NL).append("        generate(allInts(), gen -> gen.emit().items(1, 2, 3))").append(Constants.NL).append(Constants.NL).append("    is equivalent to:").append(Constants.NL).append(Constants.NL).append("        generate(all(int.class), gen -> gen.emit().items(1, 2, 3))").append(Constants.NL).append("        generate(all(Integer.class), gen -> gen.emit().items(1, 2, 3))").append(Constants.NL).append(Constants.NL).append("    with the possibility of one of the items remaining unused.").append(Constants.NL).append(Constants.NL).append(" -> Suppress this error with 'ignoreUnused()' to ignore remaining items:").append(Constants.NL).append(Constants.NL).append("        gen.emit().items(1, 2, 3, 4, 5, 6, 7).ignoreUnused()").toString();
    }
}

