/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.instancio.exception.InstancioTerminatingException;
import org.instancio.generator.GeneratorContext;
import org.instancio.internal.assignment.InternalAssignment;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.generation.AnnotationNodeHandler;
import org.instancio.internal.generation.AssigmentObjectStore;
import org.instancio.internal.generation.AssignmentNodeHandler;
import org.instancio.internal.generation.GeneratedPojoStore;
import org.instancio.internal.generation.InstantiatingHandler;
import org.instancio.internal.generation.NodeHandler;
import org.instancio.internal.generation.SpiGeneratorNodeHandler;
import org.instancio.internal.generation.UserSuppliedGeneratorHandler;
import org.instancio.internal.generation.UserSuppliedGeneratorProcessor;
import org.instancio.internal.generation.UsingGeneratorResolverHandler;
import org.instancio.internal.generator.GeneratorResolver;
import org.instancio.internal.generator.GeneratorResult;
import org.instancio.internal.generator.SpiGeneratorResolver;
import org.instancio.internal.instantiation.Instantiator;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.util.Fail;
import org.instancio.internal.util.Format;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratorFacade {
    private static final Logger LOG = LoggerFactory.getLogger(GeneratorFacade.class);
    private final ModelContext<?> context;
    private final AssignmentNodeHandler assignmentNodeHandler;
    private final NodeHandler userSuppliedGeneratorHandler;
    private final GeneratedPojoStore generatedPojoStore;
    private final List<NodeHandler> nodeHandlers = new ArrayList<NodeHandler>();

    public GeneratorFacade(ModelContext<?> context, AssigmentObjectStore assigmentObjectStore) {
        this.context = context;
        this.generatedPojoStore = GeneratedPojoStore.createStore(context);
        GeneratorContext generatorContext = new GeneratorContext(context.getSettings(), context.getRandom());
        GeneratorResolver generatorResolver = new GeneratorResolver(generatorContext);
        SpiGeneratorResolver spiGeneratorResolver = new SpiGeneratorResolver(context, generatorContext, generatorResolver);
        Instantiator instantiator = new Instantiator(context.getServiceProviders().getTypeInstantiators());
        UserSuppliedGeneratorProcessor userSuppliedGeneratorProcessor = new UserSuppliedGeneratorProcessor(context, generatorResolver, spiGeneratorResolver, instantiator);
        this.assignmentNodeHandler = AssignmentNodeHandler.create(context, assigmentObjectStore, userSuppliedGeneratorProcessor);
        this.userSuppliedGeneratorHandler = UserSuppliedGeneratorHandler.create(context, userSuppliedGeneratorProcessor);
        this.addHandler(this.assignmentNodeHandler);
        this.addHandler(this.userSuppliedGeneratorHandler);
        this.addHandler(new SpiGeneratorNodeHandler(context, spiGeneratorResolver));
        this.addHandler(AnnotationNodeHandler.create(context, generatorResolver));
        this.addHandler(new UsingGeneratorResolverHandler(context, generatorResolver));
        this.addHandler(new InstantiatingHandler(instantiator));
    }

    private void addHandler(NodeHandler handler) {
        if (handler != NodeHandler.NOOP_HANDLER) {
            this.nodeHandlers.add(handler);
        }
    }

    public GeneratorResult generateNodeValue(InternalNode node) {
        try {
            GeneratorResult result = this.getGeneratorResult(node);
            this.generatedPojoStore.putValue(node, result);
            LOG.trace("{} - {}", (Object)node, (Object)result);
            return result;
        }
        catch (InstancioTerminatingException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String msg = String.format("exception thrown by a custom Generator or Supplier%n%n -> Could not generate value for: %s (depth=%s)%n%n%s", node.toDisplayString(), node.getDepth(), Format.nodePathToRoot(node, "    "));
            throw Fail.withUsageError(msg, ex);
        }
    }

    private boolean shouldReturnNullForNullable(InternalNode node) {
        boolean precondition = this.context.isNullable(node);
        return this.context.getRandom().diceRoll(precondition);
    }

    private GeneratorResult getGeneratorResult(InternalNode node) {
        GeneratorResult result;
        block3: {
            NodeHandler handler;
            block5: {
                block4: {
                    block2: {
                        result = GeneratorResult.emptyResult();
                        if (!node.isIgnored()) break block2;
                        result = GeneratorResult.ignoredResult();
                        break block3;
                    }
                    if (!this.shouldReturnNullForNullable(node)) break block4;
                    result = GeneratorResult.nullResult();
                    break block3;
                }
                if (!node.isCyclic()) break block5;
                result = this.assignmentNodeHandler.getResult(node);
                if (result.isEmpty()) {
                    result = this.userSuppliedGeneratorHandler.getResult(node);
                }
                if (!result.isEmpty()) break block3;
                result = this.generatedPojoStore.getParentObject(node);
                break block3;
            }
            Iterator<NodeHandler> iterator = this.nodeHandlers.iterator();
            while (iterator.hasNext() && (result = (handler = iterator.next()).getResult(node)).isEmpty() && !result.isDelayed()) {
            }
        }
        return result;
    }

    public Set<InternalAssignment> getUnresolvedAssignments() {
        return this.assignmentNodeHandler.getUnresolvedAssignments();
    }
}

