/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.domain.id.pol;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import org.instancio.Random;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.time.LocalDateGenerator;

class PeselDateGenerator
extends AbstractGenerator<String> {
    private static final LocalDate MIN = LocalDate.of(1800, 1, 1);
    private static final LocalDate MAX = LocalDate.of(2300, 1, 1).minusDays(1L);
    private static final String MONTH_LITERAL = "MM";
    private static final DateTimeFormatter PESEL_DATE_FORMATTER = new DateTimeFormatterBuilder().appendPattern("uu").appendLiteral("MM").appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter();
    private Generator<LocalDate> localDateGenerator;

    PeselDateGenerator(GeneratorContext context) {
        super(context);
        this.localDateGenerator = new LocalDateGenerator(context).range(MIN, MAX);
    }

    @Override
    public String apiMethod() {
        return null;
    }

    @Override
    protected String tryGenerateNonNull(Random random) {
        LocalDate localDate = this.localDateGenerator.generate(random);
        ApiValidator.notNull(localDate, "generated PESEL date must not be null");
        return localDate.format(PESEL_DATE_FORMATTER).replace(MONTH_LITERAL, PeselDateGenerator.codedMonthFromDate(localDate));
    }

    PeselDateGenerator withLocalDate(Generator<LocalDate> localDateGenerator) {
        if (localDateGenerator != null) {
            this.localDateGenerator = localDateGenerator;
        }
        return this;
    }

    private static String codedMonthFromDate(LocalDate localDate) {
        int century = localDate.getYear() / 100;
        int codedMonth = localDate.getMonthValue();
        switch (century) {
            case 18: {
                codedMonth += 80;
                break;
            }
            case 20: {
                codedMonth += 20;
                break;
            }
            case 21: {
                codedMonth += 40;
                break;
            }
            case 22: {
                codedMonth += 60;
                break;
            }
        }
        return String.format("%02d", codedMonth);
    }
}

