/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.selectors;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.instancio.FieldSelectorBuilder;
import org.instancio.GroupableSelector;
import org.instancio.Scope;
import org.instancio.ScopeableSelector;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.selectors.PredicateScopeImpl;
import org.instancio.internal.selectors.PredicateSelectorBuilderTemplate;
import org.instancio.internal.selectors.PredicateSelectorImpl;
import org.instancio.internal.util.ErrorMessageUtils;

public class FieldSelectorBuilderImpl
extends PredicateSelectorBuilderTemplate<Field>
implements FieldSelectorBuilder {
    @Override
    protected String apiMethod() {
        return "fields()";
    }

    @Override
    protected PredicateSelectorImpl.Builder createBuilder() {
        return PredicateSelectorImpl.builder().fieldPredicate(this.buildPredicate());
    }

    @Override
    public FieldSelectorBuilder named(String fieldName) {
        ApiValidator.notNull(fieldName, () -> ErrorMessageUtils.selectorNotNullErrorMessage("field name must not be null.", "named", this.description().toString(), new Throwable()));
        this.addPredicate(field -> field.getName().equals(fieldName));
        this.description().append(".named(\"").append(fieldName).append("\")");
        return this;
    }

    @Override
    public FieldSelectorBuilder matching(String regex) {
        ApiValidator.notNull(regex, () -> ErrorMessageUtils.selectorNotNullErrorMessage("regex must not be null.", "matching", this.description().toString(), new Throwable()));
        this.addPredicate(field -> field.getName().matches(regex));
        this.description().append(".matching(\"").append(regex).append("\")");
        return this;
    }

    @Override
    public FieldSelectorBuilder ofType(Class<?> fieldType) {
        ApiValidator.notNull(fieldType, () -> ErrorMessageUtils.selectorNotNullErrorMessage("field type must not be null.", "ofType", this.description().toString(), new Throwable()));
        this.addPredicate(field -> fieldType.isAssignableFrom(field.getType()));
        this.description().append(".ofType(").append(fieldType.getSimpleName()).append(')');
        return this;
    }

    @Override
    public FieldSelectorBuilder declaredIn(Class<?> type) {
        ApiValidator.notNull(type, () -> ErrorMessageUtils.selectorNotNullErrorMessage("declaring type must not be null.", "declaredIn", this.description().toString(), new Throwable()));
        this.addPredicate(field -> field.getDeclaringClass() == type);
        this.description().append(".declaredIn(").append(type.getSimpleName()).append(')');
        return this;
    }

    @Override
    public <A extends Annotation> FieldSelectorBuilder annotated(Class<? extends A> annotation) {
        ApiValidator.notNull(annotation, () -> ErrorMessageUtils.selectorNotNullErrorMessage("field's declared annotation must not be null.", "annotated", this.description().toString(), new Throwable()));
        this.addPredicate(field -> field.getDeclaredAnnotation(annotation) != null);
        this.description().append(".annotated(").append(annotation.getSimpleName()).append(')');
        return this;
    }

    @Override
    public ScopeableSelector lenient() {
        this.setLenient();
        return this;
    }

    @Override
    public GroupableSelector within(Scope ... scopes) {
        this.withScopes(scopes);
        return this;
    }

    @Override
    public Scope toScope() {
        return new PredicateScopeImpl(this.build());
    }
}

