/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.selectors;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.instancio.GroupableSelector;
import org.instancio.PredicateSelector;
import org.instancio.Scope;
import org.instancio.ScopeableSelector;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.selectors.BaseSelector;
import org.instancio.internal.selectors.PredicateScopeImpl;
import org.instancio.internal.selectors.SelectorDepth;
import org.instancio.internal.util.Format;
import org.instancio.internal.util.ObjectUtils;
import org.instancio.internal.util.Verify;

public class PredicateSelectorImpl
extends BaseSelector
implements PredicateSelector {
    private static final int FIELD_PRIORITY = 1;
    private static final int TYPE_PRIORITY = 2;
    private static final String DEFAULT_SELECTOR_DESCRIPTION = "<selector>";
    private static final Predicate<Field> NON_NULL_FIELD = Objects::nonNull;
    private static final Predicate<Class<?>> NON_NULL_TYPE = Objects::nonNull;
    private final int priority;
    private final Predicate<InternalNode> nodePredicate;
    private final SelectorDepth selectorDepth;
    private final String apiInvocationDescription;

    protected PredicateSelectorImpl(int priority, Predicate<InternalNode> nodePredicate, List<Scope> scopes, SelectorDepth selectorDepth, boolean isLenient, boolean isHiddenFromVerboseOutput, String apiInvocationDescription, Throwable stackTraceHolder) {
        super(scopes, stackTraceHolder, isLenient, isHiddenFromVerboseOutput);
        this.priority = priority;
        this.nodePredicate = nodePredicate;
        this.selectorDepth = selectorDepth;
        this.apiInvocationDescription = apiInvocationDescription;
    }

    private PredicateSelectorImpl(Builder builder) {
        this(builder.priority, builder.nodePredicate, builder.scopes, builder.selectorDepth, builder.isLenient, builder.isHiddenFromVerboseOutput, ObjectUtils.defaultIfNull(builder.apiInvocationDescription, DEFAULT_SELECTOR_DESCRIPTION), ObjectUtils.defaultIfNull(builder.stackTraceHolder, Throwable::new));
    }

    public int getPriority() {
        return this.priority;
    }

    protected final String getApiInvocationDescription() {
        return this.apiInvocationDescription;
    }

    public Predicate<InternalNode> getNodePredicate() {
        return this.nodePredicate;
    }

    @Override
    public ScopeableSelector atDepth(int depth) {
        return this.toBuilder().depth(depth).build();
    }

    @Override
    public ScopeableSelector atDepth(Predicate<Integer> depthPredicate) {
        return this.toBuilder().depth(depthPredicate).build();
    }

    @Override
    public ScopeableSelector lenient() {
        return this.toBuilder().lenient().build();
    }

    @Override
    public Scope toScope() {
        return new PredicateScopeImpl(this);
    }

    @Override
    public GroupableSelector within(Scope ... scopes) {
        return this.toBuilder().scopes(Arrays.asList(scopes)).build();
    }

    public String toString() {
        String s = this.apiInvocationDescription;
        if (this.selectorDepth != null) {
            String depth = this.selectorDepth.getDepth() == null ? "Predicate<Integer>" : this.selectorDepth.getDepth().toString();
            s = s + ".atDepth(" + depth + ")";
        }
        if (!this.getScopes().isEmpty()) {
            s = s + ".within(" + Format.formatScopes(this.getScopes()) + ")";
        }
        if (this.isLenient()) {
            s = s + ".lenient()";
        }
        return s;
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.priority = this.priority;
        builder.nodePredicate = this.nodePredicate;
        builder.scopes = this.getScopes();
        builder.apiInvocationDescription = this.apiInvocationDescription;
        builder.stackTraceHolder = this.getStackTraceHolder();
        builder.selectorDepth = this.selectorDepth;
        builder.isLenient = this.isLenient();
        builder.isHiddenFromVerboseOutput = this.isHiddenFromVerboseOutput();
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private int priority;
        private Predicate<InternalNode> nodePredicate = Objects::nonNull;
        private List<Scope> scopes = new ArrayList<Scope>(0);
        private SelectorDepth selectorDepth;
        private boolean isLenient;
        private boolean isHiddenFromVerboseOutput;
        private String apiInvocationDescription;
        private Throwable stackTraceHolder;

        private Builder() {
        }

        public Builder fieldPredicate(Predicate<Field> predicate) {
            this.priority = 1;
            this.nodePredicate = this.nodePredicate.and(node -> NON_NULL_FIELD.and(predicate).test(node.getField()));
            if (this.apiInvocationDescription == null) {
                this.apiInvocationDescription = "fields(Predicate<Field>)";
            }
            return this;
        }

        public Builder typePredicate(Predicate<Class<?>> predicate) {
            this.priority = 2;
            this.nodePredicate = this.nodePredicate.and(node -> NON_NULL_TYPE.and(predicate).test(node.getTargetClass()));
            if (this.apiInvocationDescription == null) {
                this.apiInvocationDescription = "types(Predicate<Class>)";
            }
            return this;
        }

        public Builder scopes(List<Scope> scopes) {
            this.scopes = scopes;
            return this;
        }

        Builder depth(int depth) {
            return this.withDepth(new SelectorDepth(depth));
        }

        Builder depth(Predicate<Integer> predicate) {
            return this.withDepth(new SelectorDepth(predicate));
        }

        public Builder lenient() {
            this.isLenient = true;
            return this;
        }

        private Builder withDepth(SelectorDepth selectorDepth) {
            Verify.state(this.selectorDepth == null, "depth already set!", new Object[0]);
            this.selectorDepth = selectorDepth;
            this.nodePredicate = this.nodePredicate.and(selectorDepth.getDepthPredicate());
            return this;
        }

        public Builder apiInvocationDescription(String apiInvocationDescription) {
            this.apiInvocationDescription = apiInvocationDescription;
            return this;
        }

        public Builder stackTraceHolder(Throwable stackTraceHolder) {
            this.stackTraceHolder = stackTraceHolder;
            return this;
        }

        public PredicateSelectorImpl build() {
            return new PredicateSelectorImpl(this);
        }
    }
}

