/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.selectors;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.instancio.GroupableSelector;
import org.instancio.SelectorGroup;
import org.instancio.TargetSelector;
import org.instancio.internal.Flattener;
import org.instancio.internal.util.CollectionUtils;

public final class SelectorGroupImpl
implements SelectorGroup,
Flattener<TargetSelector> {
    private final List<GroupableSelector> selectors;
    private final List<TargetSelector> flattened = new ArrayList<TargetSelector>();

    public SelectorGroupImpl(GroupableSelector ... selectors) {
        this.selectors = CollectionUtils.asUnmodifiableList(selectors);
        for (GroupableSelector selector : selectors) {
            this.flattened.addAll(((Flattener)((Object)selector)).flatten());
        }
    }

    @Override
    public List<TargetSelector> flatten() {
        return this.flattened;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SelectorGroupImpl)) {
            return false;
        }
        SelectorGroupImpl that = (SelectorGroupImpl)o;
        return this.selectors.equals(that.selectors);
    }

    public int hashCode() {
        return this.selectors.hashCode();
    }

    public String toString() {
        if (this.selectors.isEmpty()) {
            return "all()";
        }
        return String.format("all(%n%s%n)", this.selectors.stream().map(it -> "\t" + it).collect(Collectors.joining("," + System.lineSeparator())));
    }
}

