/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.holidays.calculator.logic.parser.matcher;

import java.util.regex.Pattern;
import org.itsallcode.holidays.calculator.logic.parser.Token;

public class Patterns {
    static final String CATEGORY_GROUP = "category";
    static final String MONTH_GROUP = "month";
    static final String DAY_GROUP = "day";
    static final String OFFSET_GROUP = "offset";
    static final String OFFSET_GROUP_2 = "offset2";
    static final String DIRECTION_GROUP = "direction";
    static final String DIRECTION_GROUP_2 = "direction2";
    static final String DAY_OF_WEEK_GROUP = "dayOfWeek";
    static final String NAME_GROUP = "name";
    static final String MONTH_GROUP_2 = "month2";
    static final String DAY_GROUP_2 = "day2";
    static final String PIVOT_DAYS_OF_WEEK_GROUP = "daysOfWeek";
    public static final String SPACE_REGEXP = "\\s+";
    static final String LAST_DAY = "last-day";
    static final String NAME_REGEXP = "[a-z]+";
    private static final String NAMES_REGEXP = "[a-z,]+";
    private static final String MONTH_REGEX = "[a-z]+|0?1|0?2|0?3|0?4|0?5|0?6|0?7|0?8|0?9|10|11|12";
    private static final String DAY_REGEX = "0?1|0?2|0?3|0?4|0?5|0?6|0?7|0?8|0?9|10|11|12|13|14|15|16|17|18|19|20|21|22|23|24|25|26|27|28|29|30|31";
    private static final String OFFSET_REGEXP = "\\d\\d?";
    private static final String DIRECTION_REGEXP = "before|after";
    private static final Token CATEGORY = new Token("category", "\\S+");
    private static final Token MONTH = new Token("month", "[a-z]+|0?1|0?2|0?3|0?4|0?5|0?6|0?7|0?8|0?9|10|11|12");
    private static final Token DAY = new Token("day", "0?1|0?2|0?3|0?4|0?5|0?6|0?7|0?8|0?9|10|11|12|13|14|15|16|17|18|19|20|21|22|23|24|25|26|27|28|29|30|31");
    private static final Token DAY_OR_DEFAULT = new Token("day", Patterns.DAY.pattern + "|last-day");
    private static final Token OFFSET = new Token("offset", "[+-]?\\d\\d?");
    private static final Token POSITIVE_OFFSET = new Token("offset", "\\d\\d?");
    private static final Token POSITIVE_OFFSET_2 = new Token("offset2", "\\d\\d?");
    private static final Token DIRECTION = new Token("direction", "before|after");
    private static final Token DIRECTION_2 = new Token("direction2", "before|after");
    private static final Token DAY_OF_WEEK = new Token("dayOfWeek", "[a-z]+");
    private static final Token HOLIDAY_NAME = new Token("name", ".*");
    private static final Token MONTH_2 = new Token("month2", "[a-z]+|0?1|0?2|0?3|0?4|0?5|0?6|0?7|0?8|0?9|10|11|12");
    private static final Token DAY_2 = new Token("day2", "0?1|0?2|0?3|0?4|0?5|0?6|0?7|0?8|0?9|10|11|12|13|14|15|16|17|18|19|20|21|22|23|24|25|26|27|28|29|30|31");
    private static final Token PIVOT_DAYS_OF_WEEK = new Token("daysOfWeek", "[a-z,]+");
    static final Pattern FIXED_HOLIDAY = Token.buildRegexp(CATEGORY, "fixed", MONTH, DAY, HOLIDAY_NAME);
    static final Pattern CONDITIONAL_FIXED_HOLIDAY = Token.buildRegexp(CATEGORY, "if", MONTH_2, DAY_2, "is", PIVOT_DAYS_OF_WEEK, "then", "fixed", MONTH, DAY, HOLIDAY_NAME);
    static final Pattern FIXED_HOLIDAY_CONDITIONAL_NEGATED = Token.buildRegexp(CATEGORY, "if", MONTH_2, DAY_2, "is", "not", PIVOT_DAYS_OF_WEEK, "then", "fixed", MONTH, DAY, HOLIDAY_NAME);
    static final Pattern ALTERNATIVE_DATE_HOLIDAY = Token.buildRegexp(CATEGORY, "either", MONTH, DAY, "or", "if", PIVOT_DAYS_OF_WEEK, "then", "fixed", MONTH_2, DAY_2, HOLIDAY_NAME);
    static final Pattern ALTERNATIVE_DATE_HOLIDAY_NEGATED_DAY_OF_WEEK = Token.buildRegexp(CATEGORY, "either", MONTH, DAY, "or", "if", "not", PIVOT_DAYS_OF_WEEK, "then", "fixed", MONTH_2, DAY_2, HOLIDAY_NAME);
    static final Pattern FLOATING_HOLIDAY = Token.buildRegexp(CATEGORY, "float", POSITIVE_OFFSET, DAY_OF_WEEK, DIRECTION, MONTH, DAY_OR_DEFAULT, HOLIDAY_NAME);
    static final Pattern FLOATING_HOLIDAY_WITH_OFFSET_IN_DAYS = Token.buildRegexp(CATEGORY, "float", POSITIVE_OFFSET_2, "days?", DIRECTION_2, POSITIVE_OFFSET, DAY_OF_WEEK, DIRECTION, MONTH, DAY_OR_DEFAULT, HOLIDAY_NAME);
    static final Pattern EASTER_BASED_HOLIDAY = Token.buildRegexp(CATEGORY, "easter", OFFSET, HOLIDAY_NAME);
    static final Pattern ORTHODOX_EASTER_BASED_HOLIDAY = Token.buildRegexp(CATEGORY, "orthodox-easter", OFFSET, HOLIDAY_NAME);
}

