/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.holidays.calculator.logic.conditions.builder;

import java.time.DayOfWeek;
import java.time.MonthDay;
import java.util.List;
import org.itsallcode.holidays.calculator.logic.conditions.Condition;
import org.itsallcode.holidays.calculator.logic.conditions.DayOfWeekCondition;
import org.itsallcode.holidays.calculator.logic.conditions.NegatedCondition;
import org.itsallcode.holidays.calculator.logic.variants.Holiday;

public class ConditionBuilder {
    private boolean negated = false;
    private DayOfWeek[] daysOfWeek;
    private MonthDay pivotDate;

    public Condition build() {
        if (this.pivotDate == null) {
            throw new IllegalStateException("Cannot build DayOfWeekCondition with unspecified pivot date.");
        }
        DayOfWeekCondition condition = new DayOfWeekCondition(this.pivotDate, this.daysOfWeek);
        if (this.negated) {
            return new NegatedCondition(condition);
        }
        return condition;
    }

    public ConditionBuilder withDaysOfWeek(List<DayOfWeek> daysOfWeek) {
        this.daysOfWeek = (DayOfWeek[])daysOfWeek.toArray(DayOfWeek[]::new);
        return this;
    }

    public ConditionBuilder withPivotDate(MonthDay monthDay) {
        this.pivotDate = monthDay;
        return this;
    }

    public ConditionBuilder withOptionalPivotDateFrom(Holiday holiday) {
        if (this.pivotDate == null) {
            this.pivotDate = holiday.getMonthDay();
        }
        return this;
    }

    public ConditionBuilder negated() {
        this.negated = !this.negated;
        return this;
    }
}

