/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.data.ExecutionDataReader;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.data.SessionInfoStore;
import org.jacoco.maven.AbstractJacocoMojo;
import org.jacoco.report.FileMultiReportOutput;
import org.jacoco.report.IMultiReportOutput;
import org.jacoco.report.IReportGroupVisitor;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.MultiReportVisitor;
import org.jacoco.report.csv.CSVFormatter;
import org.jacoco.report.html.HTMLFormatter;
import org.jacoco.report.xml.XMLFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportMojo
extends AbstractJacocoMojo {
    private File outputDirectory;
    private String outputEncoding;
    private String sourceEncoding;
    private File dataFile;
    private SessionInfoStore sessionInfoStore;
    private ExecutionDataStore executionDataStore;

    @Override
    protected void executeMojo() {
        try {
            this.loadExecutionData();
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Unable to read execution data file " + this.dataFile + ": " + e.getMessage()), (Throwable)e);
            return;
        }
        try {
            IReportVisitor visitor = this.createVisitor();
            visitor.visitInfo(this.sessionInfoStore.getInfos(), this.executionDataStore.getContents());
            this.createReport((IReportGroupVisitor)visitor);
            visitor.visitEnd();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Error while creating report: " + e.getMessage()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExecutionData() throws IOException {
        this.sessionInfoStore = new SessionInfoStore();
        this.executionDataStore = new ExecutionDataStore();
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.dataFile);
            ExecutionDataReader reader = new ExecutionDataReader((InputStream)in);
            reader.setSessionInfoVisitor((ISessionInfoVisitor)this.sessionInfoStore);
            reader.setExecutionDataVisitor((IExecutionDataVisitor)this.executionDataStore);
            reader.read();
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private void createReport(IReportGroupVisitor visitor) throws IOException {
        IBundleCoverage bundle = this.createBundle();
        SourceFileCollection locator = new SourceFileCollection(this.getCompileSourceRoots(), this.sourceEncoding);
        this.checkForMissingDebugInformation((ICoverageNode)bundle);
        visitor.visitBundle(bundle, (ISourceFileLocator)locator);
    }

    private void checkForMissingDebugInformation(ICoverageNode node) {
        if (node.getClassCounter().getTotalCount() > 0 && node.getLineCounter().getTotalCount() == 0) {
            this.getLog().warn((CharSequence)"To enable source code annotation class files have to be compiled with debug information.");
        }
    }

    private IBundleCoverage createBundle() throws IOException {
        CoverageBuilder builder = new CoverageBuilder();
        Analyzer analyzer = new Analyzer(this.executionDataStore, (ICoverageVisitor)builder);
        File classesDir = new File(this.getProject().getBuild().getOutputDirectory());
        List<File> filesToAnalyze = this.getFilesToAnalyze(classesDir);
        for (File file : filesToAnalyze) {
            analyzer.analyzeAll(file);
        }
        return builder.getBundle(this.getProject().getName());
    }

    private IReportVisitor createVisitor() throws IOException {
        ArrayList<IReportVisitor> visitors = new ArrayList<IReportVisitor>();
        this.outputDirectory.mkdirs();
        XMLFormatter xmlFormatter = new XMLFormatter();
        xmlFormatter.setOutputEncoding(this.outputEncoding);
        visitors.add(xmlFormatter.createVisitor((OutputStream)new FileOutputStream(new File(this.outputDirectory, "jacoco.xml"))));
        CSVFormatter formatter = new CSVFormatter();
        formatter.setOutputEncoding(this.outputEncoding);
        visitors.add(formatter.createVisitor((OutputStream)new FileOutputStream(new File(this.outputDirectory, "jacoco.csv"))));
        HTMLFormatter htmlFormatter = new HTMLFormatter();
        htmlFormatter.setOutputEncoding(this.outputEncoding);
        visitors.add(htmlFormatter.createVisitor((IMultiReportOutput)new FileMultiReportOutput(this.outputDirectory)));
        return new MultiReportVisitor(visitors);
    }

    private File resolvePath(String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(this.getProject().getBasedir(), path);
        }
        return file;
    }

    private List<File> getCompileSourceRoots() {
        ArrayList<File> result = new ArrayList<File>();
        for (Object path : this.getProject().getCompileSourceRoots()) {
            result.add(this.resolvePath((String)path));
        }
        return result;
    }

    protected List<File> getFilesToAnalyze(File rootDir) throws IOException {
        String includes = this.getIncludes() != null && !this.getIncludes().isEmpty() ? StringUtils.join(this.getIncludes().iterator(), (String)",") : "**";
        String excludes = this.getExcludes() != null && !this.getExcludes().isEmpty() ? StringUtils.join(this.getExcludes().iterator(), (String)",") : "";
        return FileUtils.getFiles((File)rootDir, (String)includes, (String)excludes);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SourceFileCollection
    implements ISourceFileLocator {
        private final List<File> sourceRoots;
        private final String encoding;

        public SourceFileCollection(List<File> sourceRoots, String encoding) {
            this.sourceRoots = sourceRoots;
            this.encoding = encoding;
        }

        public Reader getSourceFile(String packageName, String fileName) throws IOException {
            String r = packageName.length() > 0 ? packageName + '/' + fileName : fileName;
            for (File sourceRoot : this.sourceRoots) {
                File file = new File(sourceRoot, r);
                if (!file.exists() || !file.isFile()) continue;
                return new InputStreamReader((InputStream)new FileInputStream(file), this.encoding);
            }
            return null;
        }

        public int getTabWidth() {
            return 4;
        }
    }
}

