/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.maven;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.codehaus.plexus.util.StringUtils;
import org.jacoco.core.runtime.AgentOptions;
import org.jacoco.maven.AbstractJacocoMojo;

public class AgentMojo
extends AbstractJacocoMojo {
    private static final String AGENT_ARTIFACT_NAME = "org.jacoco:org.jacoco.agent";
    private static final String TYCHO_ARG_LINE = "tycho.testArgLine";
    private static final String SUREFIRE_ARG_LINE = "argLine";
    private Map<String, Artifact> pluginArtifactMap;
    private String propertyName;
    private File destFile;
    private Boolean append;
    private String exclClassLoaders;
    private String sessionId;
    private Boolean dumpOnExit;
    private String output;
    private String address;
    private Integer port;
    private File classDumpDir;
    private Boolean jmx;

    public void executeMojo() {
        String vmArgument = StringUtils.quoteAndEscape((String)this.createAgentOptions().getVMArgument(this.getAgentJarFile()), (char)'\"');
        this.prependProperty(vmArgument);
    }

    protected void skipMojo() {
        this.prependProperty("");
    }

    private void prependProperty(String vmArgument) {
        if (this.isPropertyNameSpecified()) {
            this.prependProperty(this.propertyName, vmArgument);
        } else if (this.isEclipseTestPluginPackaging()) {
            this.prependProperty(TYCHO_ARG_LINE, vmArgument);
        } else {
            this.prependProperty(SUREFIRE_ARG_LINE, vmArgument);
        }
    }

    private File getAgentJarFile() {
        Artifact jacocoAgentArtifact = this.pluginArtifactMap.get(AGENT_ARTIFACT_NAME);
        return jacocoAgentArtifact.getFile();
    }

    private AgentOptions createAgentOptions() {
        AgentOptions agentOptions = new AgentOptions();
        agentOptions.setDestfile(this.destFile.getAbsolutePath());
        if (this.append != null) {
            agentOptions.setAppend(this.append.booleanValue());
        }
        if (this.getIncludes() != null && !this.getIncludes().isEmpty()) {
            String agentIncludes = StringUtils.join(this.getIncludes().iterator(), (String)":");
            agentOptions.setIncludes(agentIncludes);
        }
        if (this.getExcludes() != null && !this.getExcludes().isEmpty()) {
            String agentExcludes = StringUtils.join(this.getExcludes().iterator(), (String)":");
            agentOptions.setExcludes(agentExcludes);
        }
        if (this.exclClassLoaders != null) {
            agentOptions.setExclClassloader(this.exclClassLoaders);
        }
        if (this.sessionId != null) {
            agentOptions.setSessionId(this.sessionId);
        }
        if (this.dumpOnExit != null) {
            agentOptions.setDumpOnExit(this.dumpOnExit.booleanValue());
        }
        if (this.output != null) {
            agentOptions.setOutput(this.output);
        }
        if (this.address != null) {
            agentOptions.setAddress(this.address);
        }
        if (this.port != null) {
            agentOptions.setPort(this.port.intValue());
        }
        if (this.classDumpDir != null) {
            agentOptions.setClassDumpDir(this.classDumpDir.getAbsolutePath());
        }
        if (this.jmx != null) {
            agentOptions.setJmx(this.jmx.booleanValue());
        }
        return agentOptions;
    }

    private boolean isPropertyNameSpecified() {
        return this.propertyName != null && !"".equals(this.propertyName);
    }

    private boolean isEclipseTestPluginPackaging() {
        return "eclipse-test-plugin".equals(this.getProject().getPackaging());
    }

    private void prependProperty(String name, String value) {
        Properties projectProperties = this.getProject().getProperties();
        String oldValue = projectProperties.getProperty(name);
        String newValue = oldValue == null ? value : value + ' ' + oldValue;
        this.getLog().info((CharSequence)(name + " set to " + newValue));
        projectProperties.put(name, newValue);
    }
}

