/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.cli.internal;

import java.util.AbstractList;
import org.jacoco.cli.internal.Command;
import org.jacoco.cli.internal.CommandParser;
import org.jacoco.cli.internal.commands.AllCommands;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.Messages;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandHandler
extends OptionHandler<Command> {
    public CommandHandler(CmdLineParser parser, OptionDef option, Setter<Object> setter) {
        super(parser, new OptionDef(AllCommands.names(), "<command>", option.required(), option.help(), option.hidden(), CommandHandler.class, option.isMultiValued()){}, setter);
    }

    public int parseArguments(Parameters params) throws CmdLineException {
        String subCmd = params.getParameter(0);
        for (Command c : AllCommands.get()) {
            if (!c.name().equals(subCmd)) continue;
            this.parseSubArguments(c, params);
            this.setter.addValue((Object)c);
            return params.size();
        }
        throw new CmdLineException(this.owner, Messages.ILLEGAL_OPERAND.format(new Object[]{this.option.toString(), subCmd}));
    }

    private void parseSubArguments(Command c, final Parameters params) throws CmdLineException {
        CommandParser p = new CommandParser(c);
        p.parseArgument(new AbstractList<String>(){

            @Override
            public String get(int index) {
                try {
                    return params.getParameter(index + 1);
                }
                catch (CmdLineException e) {
                    throw new IndexOutOfBoundsException();
                }
            }

            @Override
            public int size() {
                return params.size() - 1;
            }
        });
    }

    public String getDefaultMetaVariable() {
        return "<command>";
    }
}

