/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.LinkedList;
import org.jamon.api.Location;

public class CodeWriter {
    static final String JAVA_SOURCE_ENCODING = "US-ASCII";
    private final PrintWriter m_writer;
    private int m_indentation = 0;
    private LinkedList<Boolean> m_argAlreadyPrintedStack = new LinkedList();
    private LinkedList<Boolean> m_itemPerLineStack = new LinkedList();
    private int nextFragmentImplCounter = 0;
    private boolean beginingOfLine = true;
    private static final int BASIC_OFFSET = 2;
    private static final String SPACES = "                                        ";

    public CodeWriter(OutputStream p_stream) {
        try {
            this.m_writer = new PrintWriter(new OutputStreamWriter(p_stream, JAVA_SOURCE_ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public CodeWriter(Writer p_writer) {
        this.m_writer = new PrintWriter(p_writer);
    }

    public int nextFragmentImplCounter() {
        return this.nextFragmentImplCounter++;
    }

    public void printLocation(Location p_location) {
        if (p_location != null) {
            this.println("// " + p_location.getLine() + ", " + p_location.getColumn());
        }
    }

    public void println() {
        this.println("");
    }

    public void println(Object p_obj) {
        this.maybeIndent();
        this.m_writer.println(p_obj);
        this.beginingOfLine = true;
    }

    public void print(Object p_obj) {
        this.maybeIndent();
        this.m_writer.print(p_obj);
        this.beginingOfLine = false;
    }

    public void openBlock() {
        this.println("{");
        this.indent();
    }

    public void closeBlock(String p_extra) {
        this.outdent();
        this.println("}" + p_extra);
    }

    public void closeBlock() {
        this.closeBlock("");
    }

    public void indent() {
        this.m_indentation += 2;
    }

    public void outdent() {
        this.m_indentation -= 2;
        if (this.m_indentation < 0) {
            throw new IllegalStateException("Attempting to outdent past 0");
        }
    }

    public void openList() {
        this.openList("(", false);
    }

    public void openList(String p_openToken, boolean p_itemPerLine) {
        this.m_argAlreadyPrintedStack.addLast(Boolean.FALSE);
        this.m_itemPerLineStack.addLast(p_itemPerLine);
        this.print(p_openToken);
        if (p_itemPerLine) {
            this.indent();
        }
    }

    public void closeList() {
        this.closeList(")");
    }

    public void closeList(String p_closeToken) {
        if (this.m_argAlreadyPrintedStack.isEmpty()) {
            throw new IllegalStateException("Attempt to close unopened list");
        }
        this.m_argAlreadyPrintedStack.removeLast();
        if (this.m_itemPerLineStack.removeLast().booleanValue()) {
            this.outdent();
        }
        this.print(p_closeToken);
    }

    public void printListElement(String p_listElement) {
        if (this.m_argAlreadyPrintedStack.isEmpty()) {
            throw new IllegalStateException("Attempt to print arg outside of list");
        }
        if (this.m_argAlreadyPrintedStack.getLast().booleanValue()) {
            if (this.m_itemPerLineStack.getLast().booleanValue()) {
                this.println(",");
            } else {
                this.print(", ");
            }
        } else {
            this.m_argAlreadyPrintedStack.removeLast();
            this.m_argAlreadyPrintedStack.addLast(Boolean.TRUE);
            if (this.m_itemPerLineStack.getLast().booleanValue()) {
                this.println();
            }
        }
        this.print(p_listElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() throws IOException {
        if (this.m_indentation != 0) {
            throw new IllegalStateException("indentation is " + this.m_indentation + " at end of file");
        }
        if (!this.m_argAlreadyPrintedStack.isEmpty()) {
            throw new IllegalStateException("in a list at end of file");
        }
        try {
            if (this.m_writer.checkError()) {
                throw new IOException("Exception writing to stream");
            }
        }
        finally {
            this.m_writer.close();
        }
    }

    private void maybeIndent() {
        if (this.beginingOfLine) {
            this.m_writer.print(SPACES.substring(0, Math.min(this.m_indentation, SPACES.length())));
        }
    }
}

