/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import java.util.LinkedList;
import java.util.List;
import org.jamon.codegen.CodeWriter;
import org.jamon.node.GenericsBoundNode;
import org.jamon.node.GenericsParamNode;

public class GenericParams {
    private final List<GenericsParamNode> m_genericsParamNodes = new LinkedList<GenericsParamNode>();

    public void addParam(GenericsParamNode p_node) {
        this.m_genericsParamNodes.add(p_node);
    }

    public String generateGenericsDeclaration() {
        return this.generateGenericsSpecifiers(true);
    }

    public String generateGenericParamsList() {
        return this.generateGenericsSpecifiers(false);
    }

    public void suppressGenericHidingWarnings(CodeWriter p_writer) {
        if (!this.m_genericsParamNodes.isEmpty()) {
            p_writer.println("@SuppressWarnings(\"hiding\")");
        }
    }

    public int getCount() {
        return this.m_genericsParamNodes.size();
    }

    private String generateGenericsSpecifiers(boolean p_forDeclaration) {
        if (this.m_genericsParamNodes.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append('<');
        boolean paramsPrinted = false;
        for (GenericsParamNode genericsParamNode : this.m_genericsParamNodes) {
            if (paramsPrinted) {
                builder.append(", ");
            } else {
                paramsPrinted = true;
            }
            builder.append(genericsParamNode.getName());
            if (!p_forDeclaration) continue;
            boolean boundsPrinted = false;
            for (GenericsBoundNode bound : genericsParamNode.getBounds()) {
                if (!boundsPrinted) {
                    builder.append(" extends ");
                    boundsPrinted = true;
                } else {
                    builder.append(" & ");
                }
                builder.append(bound.getClassName());
            }
        }
        builder.append('>');
        return builder.toString();
    }
}

