/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import org.jamon.util.StringUtils;

public class PathUtils {
    private PathUtils() {
    }

    public static String getIntfClassName(String p_path) {
        int i = p_path.lastIndexOf(47);
        return i < 0 ? p_path : p_path.substring(i + 1);
    }

    public static String getImplClassName(String p_path) {
        return PathUtils.getIntfClassName(p_path) + "Impl";
    }

    public static String getIntfPackageName(String p_path) {
        int i = p_path.lastIndexOf(47);
        if (i > 0) {
            return StringUtils.templatePathToClassName(p_path.substring(0, i));
        }
        return "";
    }

    public static String getImplPackageName(String p_path) {
        return PathUtils.getIntfPackageName(p_path);
    }

    public static String getFullyQualifiedIntfClassName(String p_path) {
        return PathUtils.fullyQualify(PathUtils.getIntfPackageName(p_path), PathUtils.getIntfClassName(p_path));
    }

    public static String getFullyQualifiedImplClassName(String p_path) {
        return PathUtils.fullyQualify(PathUtils.getImplPackageName(p_path), PathUtils.getImplClassName(p_path));
    }

    private static String fullyQualify(String p_pkgName, String p_className) {
        return "".equals(p_pkgName) ? p_className : p_pkgName + "." + p_className;
    }
}

