/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.compiler;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.jamon.api.Location;
import org.jamon.api.ParserError;
import org.jamon.api.ParserErrors;
import org.jamon.compiler.ParserErrorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParserErrorsImpl
extends IOException
implements ParserErrors {
    private final List<ParserError> m_errors = new ArrayList<ParserError>();
    private static final long serialVersionUID = 2006091701L;

    public ParserErrorsImpl() {
    }

    public ParserErrorsImpl(ParserError p_error) {
        this.m_errors.add(p_error);
    }

    public boolean hasErrors() {
        return !this.m_errors.isEmpty();
    }

    public List<ParserError> getErrors() {
        return this.m_errors;
    }

    public void addError(ParserError p_error) {
        this.m_errors.add(p_error);
    }

    public void addError(String p_message, Location p_location) {
        this.addError(new ParserErrorImpl(p_location, p_message));
    }

    public void addErrors(ParserErrorsImpl p_errors) {
        this.m_errors.addAll(p_errors.m_errors);
    }

    @Override
    public String getMessage() {
        StringBuilder buffer = new StringBuilder("Errors occured during parsing:");
        for (ParserError error : this.getErrors()) {
            buffer.append("\n   ");
            buffer.append(error.toString());
        }
        return buffer.toString();
    }

    public void printErrors(PrintStream p_stream) {
        for (ParserError error : this.getErrors()) {
            p_stream.println(error);
        }
    }
}

