/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.compiler;

import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jamon.AbstractTemplateProxy;
import org.jamon.TemplateManager;
import org.jamon.TemplateManagerSource;
import org.jamon.annotations.Argument;
import org.jamon.annotations.Template;
import org.jamon.compiler.JamonException;
import org.jamon.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateInspector {
    private final Class<?> m_templateClass;
    private final AbstractTemplateProxy m_template;
    private final Method m_renderMethod;
    private final List<String> m_requiredArgNames;
    private final List<String> m_optionalArgNames;

    public TemplateInspector(String p_templateName) throws InvalidTemplateException {
        this(TemplateManagerSource.getTemplateManagerFor((String)p_templateName), p_templateName);
    }

    public TemplateInspector(TemplateManager p_manager, String p_templateName) throws InvalidTemplateException {
        this.m_template = p_manager.constructProxy(p_templateName);
        this.m_templateClass = this.m_template.getClass();
        Method[] methods = this.m_templateClass.getMethods();
        Method renderMethod = null;
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals("render")) continue;
            renderMethod = methods[i];
            break;
        }
        if (renderMethod == null) {
            throw new InvalidTemplateException(p_templateName);
        }
        this.m_renderMethod = renderMethod;
        Template templateAnnotation = this.m_templateClass.getAnnotation(Template.class);
        this.m_requiredArgNames = this.getArgNames(templateAnnotation.requiredArguments());
        this.m_optionalArgNames = this.getArgNames(templateAnnotation.optionalArguments());
    }

    private List<String> getArgNames(Argument[] p_arguments) {
        ArrayList<String> argumentNames = new ArrayList<String>(p_arguments.length);
        for (Argument argument : p_arguments) {
            argumentNames.add(argument.name());
        }
        return argumentNames;
    }

    public void render(Writer p_writer, Map<String, Object> p_argMap) throws InvalidTemplateException, UnknownArgumentsException {
        this.render(p_writer, p_argMap, false);
    }

    public void render(Writer p_writer, Map<String, Object> p_argMap, boolean p_ignoreUnusedParams) throws InvalidTemplateException, UnknownArgumentsException {
        try {
            if (!p_ignoreUnusedParams) {
                this.validateArguments(p_argMap);
            }
            this.invokeOptionalArguments(p_argMap);
            this.m_renderMethod.invoke((Object)this.m_template, this.computeRenderArguments(p_argMap, p_writer));
        }
        catch (IllegalAccessException e) {
            throw new InvalidTemplateException(this.m_templateClass.getName(), e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new InvalidTemplateException(this.m_templateClass.getName(), t);
        }
    }

    public List<String> getRequiredArgumentNames() {
        return this.m_requiredArgNames;
    }

    public List<String> getOptionalArgumentNames() {
        return this.m_optionalArgNames;
    }

    public Class<?> getArgumentType(String p_argName) {
        if (this.m_optionalArgNames.contains(p_argName)) {
            return this.findSetMethod(p_argName).getParameterTypes()[0];
        }
        int i = this.m_requiredArgNames.indexOf(p_argName);
        if (i < 0) {
            return null;
        }
        return this.m_renderMethod.getParameterTypes()[i + 1];
    }

    private Object[] computeRenderArguments(Map<String, Object> p_argMap, Writer p_writer) {
        Object[] actuals = new Object[1 + this.m_requiredArgNames.size()];
        actuals[0] = p_writer;
        for (int i = 0; i < this.m_requiredArgNames.size(); ++i) {
            actuals[i + 1] = p_argMap.get(this.m_requiredArgNames.get(i));
        }
        return actuals;
    }

    private void invokeOptionalArguments(Map<String, Object> p_argMap) throws InvalidTemplateException {
        for (int i = 0; i < this.m_optionalArgNames.size(); ++i) {
            String name = this.m_optionalArgNames.get(i);
            if (!p_argMap.containsKey(name)) continue;
            this.invokeSet(name, p_argMap.get(name));
        }
    }

    private void validateArguments(Map<String, Object> p_argMap) throws UnknownArgumentsException {
        HashSet<String> argNames = new HashSet<String>();
        argNames.addAll(p_argMap.keySet());
        argNames.removeAll(this.m_requiredArgNames);
        argNames.removeAll(this.m_optionalArgNames);
        if (!argNames.isEmpty()) {
            StringBuilder msg = new StringBuilder("Unknown arguments supplied: ");
            StringUtils.commaJoin(msg, argNames);
            throw new UnknownArgumentsException(msg.toString());
        }
    }

    private Method findSetMethod(String p_name) {
        Method[] methods = this.m_templateClass.getMethods();
        String name = "set" + Character.toUpperCase(p_name.charAt(0)) + p_name.substring(1);
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name) || methods[i].getParameterTypes().length != 1) continue;
            return methods[i];
        }
        return null;
    }

    private void invokeSet(String p_name, Object p_value) throws InvalidTemplateException {
        Method setMethod = this.findSetMethod(p_name);
        if (setMethod == null) {
            throw new InvalidTemplateException(this.m_templateClass.getName() + " has no set method for " + p_name);
        }
        try {
            setMethod.invoke((Object)this.m_template, p_value);
        }
        catch (IllegalAccessException e) {
            throw new InvalidTemplateException(this.m_templateClass.getName(), e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new InvalidTemplateException(this.m_templateClass.getName(), t);
        }
    }

    public static class UnknownArgumentsException
    extends JamonException {
        private static final long serialVersionUID = 2006091701L;

        UnknownArgumentsException(String p_msg) {
            super(p_msg);
        }
    }

    public static class InvalidTemplateException
    extends Exception {
        private static final long serialVersionUID = 2006091701L;

        public InvalidTemplateException(String p_templateName) {
            this(p_templateName, null);
        }

        public InvalidTemplateException(String p_templateName, Throwable t) {
            super(p_templateName + " does not appear to be a valid template class", t);
        }
    }
}

