/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.compiler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import org.jamon.api.ParsedTemplate;
import org.jamon.api.SourceGenerator;
import org.jamon.api.TemplateParser;
import org.jamon.codegen.TemplateParserImpl;
import org.jamon.compiler.FileTemplateSource;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.util.StringUtils;

public class TemplateProcessor {
    private final File m_destDir;
    private final TemplateParser m_parser;
    private static final String DESTDIR = "--destDir=";
    private static final String SRCDIR = "--srcDir=";
    private static final String EMITMODE = "--emitMode=";
    private static final String CONTEXTTYPE = "--contextType";

    public TemplateProcessor(File p_destDir, File p_sourceDir, ClassLoader p_classLoader) {
        this.m_destDir = p_destDir;
        this.m_parser = new TemplateParserImpl(new FileTemplateSource(p_sourceDir), p_classLoader);
    }

    public void generateSource(String p_filename) throws IOException {
        int pPos = p_filename.indexOf(46);
        String templateName = pPos < 0 ? p_filename : p_filename.substring(0, pPos);
        File pkgDir = new File(this.m_destDir, templateName).getParentFile();
        ParsedTemplate parsedTemplate = this.m_parser.parseTemplate("/" + StringUtils.filePathToTemplatePath(templateName));
        pkgDir.mkdirs();
        this.generateSource(new File(this.m_destDir, templateName + ".java"), parsedTemplate.getProxyGenerator());
        this.generateSource(new File(this.m_destDir, templateName + "Impl.java"), parsedTemplate.getImplGenerator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateSource(File javaFile, SourceGenerator sourceGenerator) throws IOException {
        FileOutputStream out = new FileOutputStream(javaFile);
        boolean success = false;
        try {
            sourceGenerator.generateSource((OutputStream)out);
            success = true;
        }
        finally {
            out.close();
            if (!success) {
                javaFile.delete();
            }
        }
    }

    private static void showHelp() {
        System.out.println("Usage: java org.jamon.TemplateProcessor <args> templatePath*");
        System.out.println("  Arguments:");
        System.out.println("  -h|--help         - print this help");
        System.out.println("  -d|--directories  - treat paths as directories,                       and parse all .jamon files therein");
        System.out.println("  --destDir=<path>  - path to where compiled .java files go (required)");
        System.out.println("  --srcDir=<path>   - path to template directory");
        System.out.println("  --emitMode=<emitMode>  - emit mode to use - one of Standard, Limited or Strict");
        System.out.println("  --contextType<contextType>  - class type for jamonContext variable; defaults to java.lang.Object");
    }

    public static void main(String[] args) {
        try {
            int arg;
            boolean processDirectories = false;
            File sourceDir = new File(".");
            File destDir = null;
            for (arg = 0; arg < args.length && args[arg].startsWith("-"); ++arg) {
                if ("-h".equals(args[arg]) || "--help".equals(args[arg])) {
                    TemplateProcessor.showHelp();
                    System.exit(0);
                    continue;
                }
                if ("-d".equals(args[arg]) || "--directories".equals(args[arg])) {
                    processDirectories = true;
                    continue;
                }
                if (args[arg].startsWith(DESTDIR)) {
                    destDir = new File(args[arg].substring(DESTDIR.length()));
                    continue;
                }
                if (args[arg].startsWith(SRCDIR)) {
                    sourceDir = new File(args[arg].substring(SRCDIR.length()));
                    continue;
                }
                System.err.println("Unknown option: " + args[arg]);
                TemplateProcessor.showHelp();
                System.exit(1);
            }
            if (destDir == null) {
                System.err.println("You must specify --destDir=");
                TemplateProcessor.showHelp();
                System.exit(1);
                return;
            }
            destDir.mkdirs();
            if (!destDir.exists() || !destDir.isDirectory()) {
                throw new IOException("Unable to create destination dir " + destDir);
            }
            TemplateProcessor processor = new TemplateProcessor(destDir, sourceDir, TemplateProcessor.class.getClassLoader());
            while (arg < args.length) {
                if (processDirectories) {
                    String directoryName = args[arg++];
                    String fullPath = sourceDir + directoryName;
                    File directory = new File(fullPath);
                    if (!directory.isDirectory()) {
                        System.err.println(fullPath + " is not a directory");
                    }
                    File[] files = directory.listFiles(new FilenameFilter(){

                        public boolean accept(File p_dir, String p_name) {
                            return p_name.endsWith(".jamon");
                        }
                    });
                    for (int i = 0; i < files.length; ++i) {
                        processor.generateSource(directoryName + "/" + files[i].getName());
                    }
                    continue;
                }
                processor.generateSource(args[arg++]);
            }
        }
        catch (ParserErrorsImpl e) {
            e.printErrors(System.err);
            System.exit(2);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }
}

