/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.node;

import java.util.ArrayList;
import java.util.List;
import org.jamon.api.Location;
import org.jamon.node.AbstractCallNode;
import org.jamon.node.AbstractParamsNode;
import org.jamon.node.AbstractPathNode;
import org.jamon.node.Analysis;
import org.jamon.node.GenericCallParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractComponentCallNode
extends AbstractCallNode {
    private final AbstractPathNode m_callPath;
    private final List<GenericCallParam> m_genericParams = new ArrayList<GenericCallParam>();
    private final AbstractParamsNode m_params;

    public AbstractComponentCallNode(Location p_location, AbstractPathNode p_callPath, AbstractParamsNode p_params) {
        super(p_location);
        this.m_callPath = p_callPath;
        if (this.m_callPath == null) {
            throw new NullPointerException();
        }
        this.m_params = p_params;
        if (this.m_params == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public void apply(Analysis p_analysis) {
        p_analysis.caseAbstractComponentCallNode(this);
    }

    public AbstractPathNode getCallPath() {
        return this.m_callPath;
    }

    public AbstractComponentCallNode addGenericParam(GenericCallParam p_genericParam) {
        if (p_genericParam == null) {
            throw new NullPointerException();
        }
        this.m_genericParams.add(p_genericParam);
        return this;
    }

    public List<GenericCallParam> getGenericParams() {
        return this.m_genericParams;
    }

    public AbstractParamsNode getParams() {
        return this.m_params;
    }

    @Override
    public boolean equals(Object p_obj) {
        return p_obj != null && super.equals(p_obj) && this.m_callPath.equals(((AbstractComponentCallNode)p_obj).m_callPath) && ((Object)this.m_genericParams).equals(((AbstractComponentCallNode)p_obj).m_genericParams) && this.m_params.equals(((AbstractComponentCallNode)p_obj).m_params);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.m_callPath.hashCode() ^ ((Object)this.m_genericParams).hashCode() ^ this.m_params.hashCode();
    }

    @Override
    protected void propertiesToString(StringBuilder p_buffer) {
        super.propertiesToString(p_buffer);
        AbstractComponentCallNode.addProperty(p_buffer, "callPath", this.m_callPath);
        AbstractComponentCallNode.addPropertyList(p_buffer, "genericParam", this.m_genericParams);
        AbstractComponentCallNode.addProperty(p_buffer, "params", this.m_params);
    }
}

