/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.jamon.api.Location;
import org.jamon.compiler.ParserErrorImpl;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.node.AbstractBodyNode;
import org.jamon.node.AbstractNode;
import org.jamon.node.DefaultEscapeNode;
import org.jamon.node.DocNode;
import org.jamon.node.EmitNode;
import org.jamon.node.EscapeNode;
import org.jamon.node.ForNode;
import org.jamon.node.IfNode;
import org.jamon.node.JavaNode;
import org.jamon.node.LiteralNode;
import org.jamon.node.TextNode;
import org.jamon.node.WhileNode;
import org.jamon.parser.AbstractParser;
import org.jamon.parser.AbstractTagEndDetector;
import org.jamon.parser.ArgsParser;
import org.jamon.parser.CallParser;
import org.jamon.parser.ForParser;
import org.jamon.parser.FragmentArgsParser;
import org.jamon.parser.HashEndDetector;
import org.jamon.parser.IfParser;
import org.jamon.parser.PositionalPushbackReader;
import org.jamon.parser.TagEndDetector;
import org.jamon.parser.WhileParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBodyParser<Node extends AbstractBodyNode>
extends AbstractParser {
    public static final String ENCOUNTERED_ELSE_TAG_WITHOUT_PRIOR_IF_TAG = "encountered <%else> tag without prior <%if ...%> tag";
    public static final String ENCOUNTERED_ELSEIF_TAG_WITHOUT_PRIOR_IF_TAG = "encountered <%elseif ...%> tag without prior <%if ...%> tag";
    public static final String ESCAPE_TAG_IN_SUBCOMPONENT = "<%escape> tags only allowed at the top level of a document";
    public static final String GENERIC_TAG_IN_SUBCOMPONENT = "<%generic> tags only allowed at the top level of a document";
    public static final String ANNOTATE_TAG_IN_SUBCOMPONENT = "<%annotate> tags only allowed at the top level of a document";
    public static final String CLASS_TAG_IN_SUBCOMPONENT = "<%class> sections only allowed at the top level of a document";
    public static final String UNEXPECTED_NAMED_FRAGMENT_CLOSE_ERROR = "</|> tags can only be used to close named call fragments";
    public static final String UNEXPECTED_FRAGMENTS_CLOSE_ERROR = "</&> tags can only be used to close call fragments";
    public static final String EMIT_ESCAPE_CODE_ERROR = "Emit escaping code must be a letter";
    public static final String EMIT_MISSING_TAG_END_ERROR = "Did not see expected '%>' to end a <% ... %> tag";
    public static final String PERCENT_GREATER_THAN_EOF_ERROR = "Reached end of file while looking for '%>'";
    public static final String EXTENDS_TAG_IN_SUBCOMPONENT = "<%extends ...> tag only allowed at the top level of a document";
    private static final String ALIASES_TAG_IN_SUBCOMPONENT = "<%aliases> sections only allowed at the top level of a document";
    public static final String IMPLEMENTS_TAG_IN_SUBCOMPONENT = "<%implements> sections only allowed at the top level of a document";
    private static final String IMPORT_TAG_IN_SUBCOMPONENT = "<%import> sections only allowed at the top level of a document";
    public static final String PARENT_ARGS_TAG_IN_SUBCOMPONENT = "<%xargs> sections only allowed at the top level of a document";
    public static final String PARENT_MARKER_TAG_IN_SUBCOMPONENT = "<%abstract> tag only allowed at the top level of a document";
    protected StringBuilder m_text = new StringBuilder();
    protected final Node m_root;
    protected final Location m_bodyStart;
    private boolean m_doneParsing;

    protected AbstractBodyParser(Node p_rootNode, PositionalPushbackReader p_reader, ParserErrorsImpl p_errors) {
        super(p_reader, p_errors);
        this.m_root = p_rootNode;
        this.m_bodyStart = this.m_reader.getNextLocation();
    }

    protected void handleText() {
        if (this.m_text.length() > 0) {
            ((AbstractBodyNode)this.m_root).addSubNode(new TextNode(this.m_reader.getCurrentNodeLocation(), this.m_text.toString()));
            this.m_text = new StringBuilder();
        }
        this.m_reader.markNodeBeginning();
    }

    public AbstractBodyParser<Node> parse() throws IOException {
        int c;
        this.m_doneParsing = false;
        this.m_reader.markNodeEnd();
        boolean isTopLevel = this.isTopLevel();
        block10: while ((isTopLevel || !this.m_doneParsing) && (c = this.m_reader.read()) >= 0) {
            int c1;
            if (c == 60) {
                Location tagLocation = this.m_reader.getLocation();
                c1 = this.m_reader.read();
                switch (c1) {
                    case 37: {
                        this.handleText();
                        if (this.soakWhitespace()) {
                            this.handleEmit(tagLocation);
                        } else {
                            this.handleTag(this.readTagName(), tagLocation);
                        }
                        this.m_reader.markNodeEnd();
                        break;
                    }
                    case 38: {
                        this.handleText();
                        ((AbstractBodyNode)this.m_root).addSubNode(new CallParser(this.m_reader, this.m_errors, tagLocation).getCallNode());
                        this.m_reader.markNodeEnd();
                        break;
                    }
                    case 47: {
                        c = this.m_reader.read();
                        switch (c) {
                            case 37: {
                                String tagName = this.readTagName();
                                this.doneParsing();
                                if (!this.checkForTagClosure(tagLocation)) continue block10;
                                this.handleTagClose(tagName, tagLocation);
                                break;
                            }
                            case 38: {
                                if (this.readChar('>')) {
                                    if (!this.handleFragmentsClose(tagLocation)) continue block10;
                                    this.doneParsing();
                                    break;
                                }
                                this.m_text.append("</&");
                                break;
                            }
                            case 124: {
                                if (this.readChar('>')) {
                                    if (!this.handleNamedFragmentClose(tagLocation)) continue block10;
                                    this.doneParsing();
                                    break;
                                }
                                this.m_text.append("</|");
                                break;
                            }
                            default: {
                                this.m_reader.unread(c);
                                this.m_text.append("</");
                                break;
                            }
                        }
                        continue block10;
                    }
                    default: {
                        if (c1 >= 0) {
                            this.m_reader.unread(c1);
                        }
                        this.m_text.append((char)c);
                    }
                }
                continue;
            }
            if (c == 37 && this.m_reader.isLineStart()) {
                this.handleText();
                ((AbstractBodyNode)this.m_root).addSubNode(new JavaNode(this.m_reader.getCurrentNodeLocation(), this.readLine()));
                this.m_reader.markNodeEnd();
                continue;
            }
            if (c == 92) {
                ArrayList<Integer> toPushBack = new ArrayList<Integer>();
                c1 = this.m_reader.read();
                toPushBack.add(c1);
                if (c1 == 13) {
                    c1 = this.m_reader.read();
                    toPushBack.add(0, c1);
                }
                if (c1 == 10) continue;
                this.m_text.append((char)c);
                Iterator i$ = toPushBack.iterator();
                while (i$.hasNext()) {
                    int c2 = (Integer)i$.next();
                    this.m_reader.unread(c2);
                }
                continue;
            }
            this.m_text.append((char)c);
        }
        this.handleText();
        if (!this.m_doneParsing && !isTopLevel) {
            this.handleEof();
        }
        return this;
    }

    protected void doneParsing() {
        this.m_doneParsing = true;
    }

    private void handleEmit(Location p_tagLocation) throws IOException {
        try {
            HashEndDetector endDetector = new HashEndDetector();
            String emitExpr = this.readJava(p_tagLocation, endDetector);
            if (!endDetector.endedWithHash()) {
                ((AbstractBodyNode)this.m_root).addSubNode(new EmitNode(p_tagLocation, emitExpr, new DefaultEscapeNode(this.m_reader.getLocation())));
            } else {
                Location escapingLocation = this.m_reader.getLocation();
                int c = this.m_reader.read();
                if (this.isLetter((char)c)) {
                    this.soakWhitespace();
                    if (this.readChar('%') && this.readChar('>')) {
                        ((AbstractBodyNode)this.m_root).addSubNode(new EmitNode(p_tagLocation, emitExpr, new EscapeNode(escapingLocation, Character.toString((char)c))));
                    } else {
                        this.addError(this.m_reader.getLocation(), EMIT_MISSING_TAG_END_ERROR);
                    }
                } else {
                    this.addError(this.m_reader.getLocation(), EMIT_ESCAPE_CODE_ERROR);
                }
            }
        }
        catch (ParserErrorImpl e) {
            this.addError(e);
        }
    }

    private boolean isLetter(char p_char) {
        return 'A' <= p_char && p_char <= 'Z' || 'a' <= p_char && p_char <= 'z';
    }

    protected boolean isTopLevel() {
        return false;
    }

    protected void handleTag(String p_tagName, Location p_tagLocation) throws IOException {
        if ("java".equals(p_tagName)) {
            this.handleJavaTag(p_tagLocation);
        } else if ("LITERAL".equals(p_tagName)) {
            this.handleLiteralTag(p_tagLocation);
        } else if ("def".equals(p_tagName)) {
            this.handleDefTag(p_tagLocation);
        } else if ("method".equals(p_tagName)) {
            this.handleMethodTag(p_tagLocation);
        } else if ("override".equals(p_tagName)) {
            this.handleOverrideTag(p_tagLocation);
        } else if ("while".equals(p_tagName)) {
            this.handleWhileTag(p_tagLocation);
        } else if ("for".equals(p_tagName)) {
            this.handleForTag(p_tagLocation);
        } else if ("if".equals(p_tagName)) {
            this.handleIfTag(p_tagLocation);
        } else if ("else".equals(p_tagName)) {
            this.handleElseTag(p_tagLocation);
        } else if ("elseif".equals(p_tagName)) {
            this.handleElseIfTag(p_tagLocation);
        } else if ("args".equals(p_tagName)) {
            try {
                ((AbstractBodyNode)this.m_root).addSubNode(new ArgsParser(this.m_reader, this.m_errors, p_tagLocation).getArgsNode());
            }
            catch (ParserErrorImpl e) {
                this.addError(e);
            }
        } else if ("frag".equals(p_tagName)) {
            try {
                ((AbstractBodyNode)this.m_root).addSubNode(new FragmentArgsParser(this.m_reader, this.m_errors, p_tagLocation).getFragmentArgsNode());
            }
            catch (ParserErrorImpl e) {
                this.addError(e);
            }
        } else if ("xargs".equals(p_tagName)) {
            this.handleParentArgsNode(p_tagLocation);
        } else if ("class".equals(p_tagName)) {
            this.handleClassTag(p_tagLocation);
        } else if ("extends".equals(p_tagName)) {
            this.handleExtendsTag(p_tagLocation);
        } else if ("alias".equals(p_tagName)) {
            this.handleAliasesTag(p_tagLocation);
        } else if ("absmeth".equals(p_tagName)) {
            this.handleAbsMethodTag(p_tagLocation);
        } else if ("implements".equals(p_tagName)) {
            this.handleImplementsTag(p_tagLocation);
        } else if ("import".equals(p_tagName)) {
            this.handleImportTag(p_tagLocation);
        } else if ("doc".equals(p_tagName)) {
            this.handleDocTag(p_tagLocation);
        } else if ("abstract".equals(p_tagName)) {
            this.handleParentMarkerTag(p_tagLocation);
        } else if ("escape".equals(p_tagName)) {
            this.handleEscapeTag(p_tagLocation);
        } else if ("generic".equals(p_tagName)) {
            this.handleGenericTag(p_tagLocation);
        } else if ("annotate".equals(p_tagName)) {
            this.handleAnnotationTag(p_tagLocation);
        } else if (this.checkForTagClosure(p_tagLocation)) {
            this.addError(p_tagLocation, "Unknown tag <%" + p_tagName + ">");
        }
    }

    protected void handleTagClose(String p_tagName, Location p_tagLocation) throws IOException {
        this.addError(p_tagLocation, "Unexpected tag close </%" + p_tagName + ">");
    }

    protected abstract void handleEof();

    protected boolean handleNamedFragmentClose(Location p_tagLocation) throws IOException {
        this.addError(p_tagLocation, UNEXPECTED_NAMED_FRAGMENT_CLOSE_ERROR);
        return false;
    }

    protected boolean handleFragmentsClose(Location p_tagLocation) throws IOException {
        this.addError(p_tagLocation, UNEXPECTED_FRAGMENTS_CLOSE_ERROR);
        return false;
    }

    protected void handleMethodTag(Location p_tagLocation) throws IOException {
        this.addError(p_tagLocation, "<%method> sections only allowed at the top level of a document");
    }

    protected void handleOverrideTag(Location p_tagLocation) throws IOException {
        this.addError(p_tagLocation, "<%override> sections only allowed at the top level of a document");
    }

    protected void handleDefTag(Location p_tagLocation) throws IOException {
        this.addError(p_tagLocation, "<%def> sections only allowed at the top level of a document");
    }

    protected void handleAbsMethodTag(Location p_tagLocation) throws IOException {
        this.addError(p_tagLocation, "<%absmeth> sections only allowed at the top level of a document");
    }

    protected void handleWhileTag(Location p_tagLocation) throws IOException {
        try {
            ((AbstractBodyNode)this.m_root).addSubNode((AbstractNode)new WhileParser(new WhileNode(p_tagLocation, this.readCondition(p_tagLocation, "while")), this.m_reader, this.m_errors).parse().getRootNode());
        }
        catch (ParserErrorImpl e) {
            this.addError(e);
        }
    }

    protected void handleForTag(Location p_tagLocation) throws IOException {
        try {
            ((AbstractBodyNode)this.m_root).addSubNode((AbstractNode)new ForParser(new ForNode(p_tagLocation, this.readCondition(p_tagLocation, "for")), this.m_reader, this.m_errors).parse().getRootNode());
        }
        catch (ParserErrorImpl e) {
            this.addError(e);
        }
    }

    protected void handleIfTag(Location p_tagLocation) throws IOException {
        try {
            IfParser parser;
            parser.parse();
            for (parser = new IfParser(new IfNode(p_tagLocation, this.readCondition(p_tagLocation, "if")), this.m_reader, this.m_errors); parser != null; parser = parser.getContinuation()) {
                ((AbstractBodyNode)this.m_root).addSubNode((AbstractNode)parser.getRootNode());
            }
        }
        catch (ParserErrorImpl e) {
            this.addError(e);
        }
    }

    protected String readCondition(Location p_tagLocation, String p_tagName) throws IOException, ParserErrorImpl {
        if (!this.soakWhitespace()) {
            throw new ParserErrorImpl(p_tagLocation, "Malformed <%" + p_tagName + " ...%> tag");
        }
        return this.readJava(p_tagLocation, new ConditionEndDetector("<%" + p_tagName + " ...%>"));
    }

    protected void handleElseTag(Location p_tagLocation) throws IOException {
        this.addError(p_tagLocation, ENCOUNTERED_ELSE_TAG_WITHOUT_PRIOR_IF_TAG);
    }

    protected void handleElseIfTag(Location p_tagLocation) throws IOException {
        this.addError(p_tagLocation, ENCOUNTERED_ELSEIF_TAG_WITHOUT_PRIOR_IF_TAG);
    }

    protected void handleParentArgsNode(Location p_tagLocation) throws IOException {
        this.addError(p_tagLocation, PARENT_ARGS_TAG_IN_SUBCOMPONENT);
    }

    protected void handleParentMarkerTag(Location p_tagLocation) throws IOException {
        this.addError(p_tagLocation, PARENT_MARKER_TAG_IN_SUBCOMPONENT);
    }

    protected void handleEscapeTag(Location p_tagLocation) throws IOException {
        this.addError(p_tagLocation, ESCAPE_TAG_IN_SUBCOMPONENT);
    }

    protected void handleGenericTag(Location p_tagLocation) throws IOException {
        this.addError(p_tagLocation, GENERIC_TAG_IN_SUBCOMPONENT);
    }

    protected void handleAnnotationTag(Location p_tagLocation) throws IOException {
        this.addError(p_tagLocation, ANNOTATE_TAG_IN_SUBCOMPONENT);
    }

    private void handleJavaTag(Location p_tagLocation) throws IOException {
        if (this.readChar('>')) {
            this.handleJavaCode(p_tagLocation, new JavaTagEndDetector());
        } else {
            this.soakWhitespace();
            this.handleJavaCode(p_tagLocation, new JavaSnippetTagEndDetector());
        }
    }

    private void handleJavaCode(Location p_tagLocation, TagEndDetector p_endTagDetector) throws IOException {
        try {
            ((AbstractBodyNode)this.m_root).addSubNode(new JavaNode(p_tagLocation, this.readJava(p_tagLocation, p_endTagDetector)));
            this.soakWhitespace();
        }
        catch (ParserErrorImpl e) {
            this.addError(e);
        }
    }

    protected void handleLiteralTag(Location p_tagLocation) throws IOException {
        if (this.checkForTagClosure(p_tagLocation)) {
            ((AbstractBodyNode)this.m_root).addSubNode(new LiteralNode(p_tagLocation, this.readUntil("</%LITERAL>", p_tagLocation)));
        }
    }

    protected void handleClassTag(Location p_tagLocation) throws IOException {
        this.addError(p_tagLocation, CLASS_TAG_IN_SUBCOMPONENT);
    }

    protected void handleExtendsTag(Location p_tagLocation) throws IOException {
        this.addError(p_tagLocation, EXTENDS_TAG_IN_SUBCOMPONENT);
    }

    protected void handleImplementsTag(Location p_tagLocation) throws IOException {
        this.addError(p_tagLocation, IMPLEMENTS_TAG_IN_SUBCOMPONENT);
    }

    protected void handleImportTag(Location p_tagLocation) throws IOException {
        this.addError(p_tagLocation, IMPORT_TAG_IN_SUBCOMPONENT);
    }

    protected void handleAliasesTag(Location p_tagLocation) throws IOException {
        this.addError(p_tagLocation, ALIASES_TAG_IN_SUBCOMPONENT);
    }

    private void handleDocTag(Location p_tagLocation) throws IOException {
        if (this.checkForTagClosure(p_tagLocation)) {
            ((AbstractBodyNode)this.m_root).addSubNode(new DocNode(p_tagLocation, this.readUntil("</%doc>", p_tagLocation)));
        }
        this.soakWhitespace();
    }

    protected String readTagName() throws IOException {
        int c;
        StringBuilder buffer = new StringBuilder();
        while ((c = this.m_reader.read()) >= 0 && !Character.isWhitespace((char)c) && c != 62) {
            buffer.append((char)c);
        }
        if (c >= 0) {
            this.m_reader.unread(c);
        }
        return buffer.toString();
    }

    protected String readLine() throws IOException {
        int c;
        StringBuilder line = new StringBuilder();
        while ((c = this.m_reader.read()) >= 0) {
            line.append((char)c);
            if (c != 10) continue;
            break;
        }
        return line.toString();
    }

    public Node getRootNode() {
        return this.m_root;
    }

    protected static class JavaSnippetTagEndDetector
    extends AbstractTagEndDetector {
        protected JavaSnippetTagEndDetector() {
            super("%>");
        }
    }

    private static class JavaTagEndDetector
    extends AbstractTagEndDetector {
        public JavaTagEndDetector() {
            super("</%java>");
        }
    }

    private static class ConditionEndDetector
    implements TagEndDetector {
        private boolean m_seenPercent = false;
        private final String m_tagName;

        public ConditionEndDetector(String p_tagName) {
            this.m_tagName = p_tagName;
        }

        public int checkEnd(char p_char) {
            switch (p_char) {
                case '%': {
                    this.m_seenPercent = true;
                    return 0;
                }
                case '>': {
                    if (this.m_seenPercent) {
                        return 2;
                    }
                    this.m_seenPercent = false;
                    return 0;
                }
            }
            this.m_seenPercent = false;
            return 0;
        }

        public ParserErrorImpl getEofError(Location p_startLocation) {
            return new ParserErrorImpl(p_startLocation, "Reached end of file while reading " + this.m_tagName + " tag");
        }

        public void resetEndMatch() {
        }
    }
}

