/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jamon.api.Location;
import org.jamon.compiler.ParserErrorImpl;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.node.AbsolutePathNode;
import org.jamon.node.AbstractCallNode;
import org.jamon.node.AbstractComponentCallNode;
import org.jamon.node.AbstractParamsNode;
import org.jamon.node.AbstractPathNode;
import org.jamon.node.ChildCallNode;
import org.jamon.node.FragmentCallNode;
import org.jamon.node.GenericCallParam;
import org.jamon.node.MultiFragmentCallNode;
import org.jamon.node.NamedFragmentNode;
import org.jamon.node.NamedParamNode;
import org.jamon.node.NamedParamsNode;
import org.jamon.node.NoParamsNode;
import org.jamon.node.ParamNameNode;
import org.jamon.node.ParamValueNode;
import org.jamon.node.SimpleCallNode;
import org.jamon.node.UnnamedFragmentNode;
import org.jamon.node.UnnamedParamsNode;
import org.jamon.parser.AbstractParser;
import org.jamon.parser.ClassNameParser;
import org.jamon.parser.NamedFragmentParser;
import org.jamon.parser.PositionalPushbackReader;
import org.jamon.parser.TagEndDetector;
import org.jamon.parser.UnnamedFragmentParser;

public class CallParser
extends AbstractParser {
    public static final String INVALID_CALL_TARGET_ERROR = "Invalid call target";
    public static final String MISSING_CALL_CLOSE_ERROR = "Expecting '&>'";
    public static final String UNEXPECTED_IN_MULTI_FRAG_ERROR = "Expecting either '<|identifier>' or '</&>'";
    public static final String MISSING_ARG_ARROW_ERROR = "Expecting '=' or '=>' to separate param name and value";
    public static final String GENERIC_ERROR = "Malformed call tag";
    public static final String PARAM_VALUE_EOF_ERROR = "Reached end of file while reading parameter value";
    public static final String FRAGMENTS_EOF_ERROR = "Reached end of file while reading call fragments; '</&>' Expected";
    public static final String MISSING_GENERIC_PARAM_CLOSE_ERROR = "Expecing ',' or '>'";
    private AbstractCallNode m_callNode;
    private List<GenericCallParam> m_genericParams = null;

    public CallParser(PositionalPushbackReader p_reader, ParserErrorsImpl p_errors, Location p_callStartLocation) throws IOException {
        super(p_reader, p_errors);
        try {
            if (this.readChar('|')) {
                this.m_callNode = this.readChar('|') ? this.parseNamedFragmentCall(p_callStartLocation) : this.parseUnnamedFragmentCall(p_callStartLocation);
                this.addGenericParams();
            } else {
                this.soakWhitespace();
                if (this.readChar('*')) {
                    this.parseChildCall(p_callStartLocation);
                } else {
                    AbstractPathNode path = this.parsePath();
                    this.parseGenericParams();
                    this.m_callNode = new SimpleCallNode(p_callStartLocation, path, this.parseParams());
                    this.addGenericParams();
                }
            }
        }
        catch (ParserErrorImpl e) {
            this.addError(e);
            this.m_callNode = new SimpleCallNode(p_callStartLocation, new AbsolutePathNode(p_callStartLocation), new NoParamsNode(this.m_reader.getLocation()));
        }
    }

    private void parseChildCall(Location p_callStartLocation) throws IOException, ParserErrorImpl {
        Location callTargetLocation = this.m_reader.getLocation();
        if (this.checkToken("CHILD")) {
            this.soakWhitespace();
            Location endLocation = this.m_reader.getNextLocation();
            if (!this.checkToken("&>")) {
                throw new ParserErrorImpl(endLocation, MISSING_CALL_CLOSE_ERROR);
            }
        } else {
            throw new ParserErrorImpl(callTargetLocation, INVALID_CALL_TARGET_ERROR);
        }
        this.m_callNode = new ChildCallNode(p_callStartLocation);
    }

    private AbstractComponentCallNode parseNamedFragmentCall(Location p_callStartLocation) throws IOException, ParserErrorImpl {
        int c;
        this.soakWhitespace();
        AbstractPathNode path = this.parsePath();
        this.parseGenericParams();
        MultiFragmentCallNode callNode = new MultiFragmentCallNode(p_callStartLocation, path, this.parseParams());
        Location fragmentsStart = this.m_reader.getNextLocation();
        while (true) {
            this.soakWhitespace();
            Location fragmentStart = this.m_reader.getNextLocation();
            c = this.m_reader.read();
            if (c != 60) break;
            switch (this.m_reader.read()) {
                case 124: {
                    String name = this.readIdentifier(true);
                    if (this.readChar('>')) {
                        NamedFragmentNode fragmentNode = new NamedFragmentNode(fragmentStart, name);
                        new NamedFragmentParser(fragmentNode, this.m_reader, this.m_errors).parse();
                        callNode.addFragment(fragmentNode);
                        break;
                    }
                    throw new ParserErrorImpl(this.m_reader.getLocation(), UNEXPECTED_IN_MULTI_FRAG_ERROR);
                }
                case 47: {
                    if (this.readChar('&') && this.readChar('>')) {
                        return callNode;
                    }
                    throw new ParserErrorImpl(this.m_reader.getLocation(), UNEXPECTED_IN_MULTI_FRAG_ERROR);
                }
                default: {
                    throw new ParserErrorImpl(this.m_reader.getLocation(), UNEXPECTED_IN_MULTI_FRAG_ERROR);
                }
            }
        }
        if (c >= 0) {
            throw new ParserErrorImpl(this.m_reader.getLocation(), UNEXPECTED_IN_MULTI_FRAG_ERROR);
        }
        throw new ParserErrorImpl(fragmentsStart, FRAGMENTS_EOF_ERROR);
    }

    private FragmentCallNode parseUnnamedFragmentCall(Location p_callStartLocation) throws IOException, ParserErrorImpl {
        this.soakWhitespace();
        AbstractPathNode path = this.parsePath();
        this.parseGenericParams();
        AbstractParamsNode params = this.parseParams();
        return new FragmentCallNode(p_callStartLocation, path, params, (UnnamedFragmentNode)new UnnamedFragmentParser(new UnnamedFragmentNode(this.m_reader.getNextLocation()), this.m_reader, this.m_errors).parse().getRootNode());
    }

    private AbstractParamsNode parseParams() throws IOException, ParserErrorImpl {
        this.soakWhitespace();
        this.m_reader.markNodeEnd();
        int c = this.m_reader.read();
        switch (c) {
            case 38: {
                if (this.m_reader.read() == 62) {
                    return new NoParamsNode(this.m_reader.getCurrentNodeLocation());
                }
                throw new ParserErrorImpl(this.m_reader.getLocation(), GENERIC_ERROR);
            }
            case 59: {
                return this.parseNamedParams();
            }
            case 58: {
                return this.parseUnnamedParams();
            }
        }
        throw new ParserErrorImpl(this.m_reader.getLocation(), GENERIC_ERROR);
    }

    private NamedParamsNode parseNamedParams() throws ParserErrorImpl, IOException {
        NamedParamsNode params = new NamedParamsNode(this.m_reader.getLocation());
        ParamValueEndDetector endDetector = new ParamValueEndDetector();
        do {
            this.soakWhitespace();
            if (this.readChar('&')) {
                if (this.readChar('>')) {
                    return params;
                }
                throw new ParserErrorImpl(this.m_reader.getCurrentNodeLocation(), GENERIC_ERROR);
            }
            Location nameLoc = this.m_reader.getNextLocation();
            String name = this.readIdentifier(true);
            this.readArrow();
            Location javaLoc = this.m_reader.getNextLocation();
            params.addParam(new NamedParamNode(nameLoc, new ParamNameNode(nameLoc, name), new ParamValueNode(javaLoc, this.readJava(javaLoc, endDetector))));
        } while (!endDetector.noMoreParams());
        return params;
    }

    private UnnamedParamsNode parseUnnamedParams() throws ParserErrorImpl, IOException {
        UnnamedParamsNode params = new UnnamedParamsNode(this.m_reader.getLocation());
        ParamValueEndDetector endDetector = new ParamValueEndDetector();
        do {
            this.soakWhitespace();
            if (this.readChar('&')) {
                if (this.readChar('>')) {
                    return params;
                }
                throw new ParserErrorImpl(this.m_reader.getCurrentNodeLocation(), GENERIC_ERROR);
            }
            Location javaLoc = this.m_reader.getNextLocation();
            params.addValue(new ParamValueNode(javaLoc, this.readJava(javaLoc, endDetector)));
        } while (!endDetector.noMoreParams());
        return params;
    }

    private void parseGenericParams() throws ParserErrorImpl, IOException {
        this.m_genericParams = new ArrayList<GenericCallParam>();
        if (this.readChar('<')) {
            do {
                this.soakWhitespace();
                Location location = this.m_reader.getNextLocation();
                this.m_genericParams.add(new GenericCallParam(location, new ClassNameParser(location, this.m_reader, this.m_errors).getType()));
                this.soakWhitespace();
            } while (this.readChar(','));
            if (!this.readChar('>')) {
                throw new ParserErrorImpl(this.m_reader.getNextLocation(), MISSING_GENERIC_PARAM_CLOSE_ERROR);
            }
        }
    }

    private void addGenericParams() {
        AbstractComponentCallNode callNode = (AbstractComponentCallNode)this.m_callNode;
        for (GenericCallParam param : this.m_genericParams) {
            callNode.addGenericParam(param);
        }
    }

    private void readArrow() throws ParserErrorImpl, IOException {
        this.soakWhitespace();
        if (!this.readChar('=')) {
            throw new ParserErrorImpl(this.m_reader.getNextLocation(), MISSING_ARG_ARROW_ERROR);
        }
        this.readChar('>');
        this.soakWhitespace();
    }

    public static void main(String[] args) {
    }

    public AbstractCallNode getCallNode() {
        return this.m_callNode;
    }

    private static class ParamValueEndDetector
    implements TagEndDetector {
        private boolean m_noMoreParams = false;
        private boolean m_seenAmpersand = false;

        private ParamValueEndDetector() {
        }

        public boolean noMoreParams() {
            return this.m_noMoreParams;
        }

        public int checkEnd(char p_char) {
            if (p_char == '&') {
                this.m_seenAmpersand = true;
                return 0;
            }
            if (p_char == '>' && this.m_seenAmpersand) {
                this.m_noMoreParams = true;
                return 2;
            }
            if (p_char == ';') {
                return 1;
            }
            this.m_seenAmpersand = false;
            return 0;
        }

        public ParserErrorImpl getEofError(Location p_startLocation) {
            return new ParserErrorImpl(p_startLocation, CallParser.PARAM_VALUE_EOF_ERROR);
        }

        public void resetEndMatch() {
            this.m_seenAmpersand = false;
        }
    }
}

