/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.parser;

import java.io.IOException;
import org.jamon.api.Location;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.node.AbsolutePathNode;
import org.jamon.node.AbstractPathNode;
import org.jamon.node.NamedAliasPathNode;
import org.jamon.node.PathElementNode;
import org.jamon.node.RelativePathNode;
import org.jamon.node.RootAliasPathNode;
import org.jamon.node.UpdirNode;
import org.jamon.parser.AbstractParser;
import org.jamon.parser.PositionalPushbackReader;

public class PathParser
extends AbstractParser {
    public static final String GENERIC_PATH_ERROR = "Malformed path";
    private final AbstractPathNode m_path = this.parse();

    public PathParser(PositionalPushbackReader p_reader, ParserErrorsImpl p_errors) throws IOException {
        super(p_reader, p_errors);
    }

    public AbstractPathNode getPathNode() {
        return this.m_path;
    }

    private AbstractPathNode parse() throws IOException {
        AbstractPathNode path;
        Location location = this.m_reader.getNextLocation();
        int c = this.m_reader.read();
        switch (c) {
            case 47: {
                path = this.readChar('/') ? new RootAliasPathNode(location) : new AbsolutePathNode(location);
                this.addToPath(path, false);
                break;
            }
            case 46: {
                this.m_reader.unread(c);
                path = new RelativePathNode(location);
                this.addToPath(path, true);
                break;
            }
            default: {
                if (Character.isJavaIdentifierStart((char)c)) {
                    this.m_reader.unread(c);
                    String identifier = this.readIdentifier(true);
                    c = this.m_reader.read();
                    if (c == 47) {
                        c = this.m_reader.read();
                        if (c == 47) {
                            path = new NamedAliasPathNode(location, identifier);
                            this.addToPath(path, false);
                            break;
                        }
                        this.m_reader.unread(c);
                        path = new RelativePathNode(location).addPathElement(new PathElementNode(location, identifier));
                        this.addToPath(path, false);
                        break;
                    }
                    this.m_reader.unread(c);
                    path = new RelativePathNode(location).addPathElement(new PathElementNode(location, identifier));
                    break;
                }
                this.addError(location, GENERIC_PATH_ERROR);
                path = new RelativePathNode(location);
            }
        }
        return path;
    }

    private void addToPath(AbstractPathNode p_path, boolean p_updirsAllowed) throws IOException {
        int c;
        StringBuilder identifier = new StringBuilder();
        boolean identStart = true;
        boolean updirsAllowed = p_updirsAllowed;
        Location location = this.m_reader.getNextLocation();
        while ((c = this.m_reader.read()) >= 0) {
            if (c == 47) {
                if (identStart) {
                    this.addError(location, GENERIC_PATH_ERROR);
                    return;
                }
                p_path.addPathElement(new PathElementNode(location, identifier.toString()));
                identifier = new StringBuilder();
                identStart = true;
                updirsAllowed = false;
                location = this.m_reader.getNextLocation();
                continue;
            }
            if (c == 46) {
                if (updirsAllowed) {
                    if (this.m_reader.read() == 46) {
                        p_path.addPathElement(new UpdirNode(location));
                        identifier = new StringBuilder();
                        identStart = true;
                        c = this.m_reader.read();
                        if (c == 47) {
                            location = this.m_reader.getNextLocation();
                            continue;
                        }
                        if (!Character.isJavaIdentifierPart((char)c)) continue;
                        this.addError(location, GENERIC_PATH_ERROR);
                        return;
                    }
                    this.addError(location, GENERIC_PATH_ERROR);
                    return;
                }
                this.addError(location, GENERIC_PATH_ERROR);
                return;
            }
            if (identStart ? Character.isJavaIdentifierStart((char)c) : Character.isJavaIdentifierPart((char)c)) {
                identStart = false;
                identifier.append((char)c);
                continue;
            }
            this.m_reader.unread(c);
            break;
        }
        if (!identStart) {
            p_path.addPathElement(new PathElementNode(location, identifier.toString()));
        } else {
            this.addError(this.m_reader.getCurrentNodeLocation(), GENERIC_PATH_ERROR);
        }
    }
}

