/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.jamon.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkDirClassLoader
extends ClassLoader {
    private final String m_workDir;
    private Loader m_loader;

    public WorkDirClassLoader(ClassLoader p_parent, String p_workDir) {
        super(p_parent);
        this.m_workDir = p_workDir;
    }

    private File getFileForClass(String p_name) {
        return new File(this.m_workDir, StringUtils.classNameToFilePath(p_name) + ".class");
    }

    public synchronized void invalidate() {
        this.m_loader = null;
    }

    @Override
    protected synchronized Class<?> loadClass(String p_name, boolean p_resolve) throws ClassNotFoundException {
        if (!this.getFileForClass(p_name).exists()) {
            return super.loadClass(p_name, p_resolve);
        }
        if (this.m_loader == null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    WorkDirClassLoader.this.m_loader = new Loader();
                    return null;
                }
            });
        }
        return this.m_loader.loadClass(p_name, p_resolve);
    }

    public String toString() {
        return super.toString() + " { workDir: " + this.m_workDir + "; parent: " + this.getParent() + " }";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Loader
    extends ClassLoader {
        private final Map<String, Class<?>> m_cache;

        Loader() {
            super(WorkDirClassLoader.this);
            this.m_cache = new HashMap();
        }

        public String toString() {
            return super.toString() + " { " + " parent: " + this.getParent() + " }";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] readBytesForClass(String p_name) throws IOException {
            FileInputStream s = new FileInputStream(WorkDirClassLoader.this.getFileForClass(p_name));
            try {
                int i;
                byte[] buf = new byte[1024];
                byte[] bytes = new byte[]{};
                while ((i = s.read(buf)) > 0) {
                    byte[] newbytes = new byte[bytes.length + i];
                    System.arraycopy(bytes, 0, newbytes, 0, bytes.length);
                    System.arraycopy(buf, 0, newbytes, bytes.length, i);
                    bytes = newbytes;
                }
                byte[] byArray = bytes;
                return byArray;
            }
            finally {
                s.close();
            }
        }

        @Override
        protected Class<?> loadClass(String p_name, boolean p_resolve) throws ClassNotFoundException {
            if (!WorkDirClassLoader.this.getFileForClass(p_name).exists()) {
                return super.loadClass(p_name, p_resolve);
            }
            Class<?> c = this.m_cache.get(p_name);
            if (c == null) {
                try {
                    byte[] code = this.readBytesForClass(p_name);
                    c = this.defineClass(p_name, code, 0, code.length);
                    if (p_resolve) {
                        this.resolveClass(c);
                    }
                    this.m_cache.put(p_name, c);
                }
                catch (IOException e) {
                    throw new ClassNotFoundException(e.getMessage());
                }
            }
            return c;
        }
    }
}

