package org.jamon.node;

import java.util.ArrayList;
import java.util.List;

import org.jamon.api.Location;
public class AbstractComponentCallNode extends AbstractCallNode {
  public AbstractComponentCallNode(Location location, AbstractPathNode callPath, AbstractParamsNode params) {
    super(location);
    if ((this.callPath = callPath) == null)
      { throw new NullPointerException(); }
    if ((this.params = params) == null)
      { throw new NullPointerException(); }
  }

  @Override public void apply(Analysis analysis)
  {
    analysis.caseAbstractComponentCallNode(this);
  }

  private final AbstractPathNode callPath;
  public AbstractPathNode getCallPath() { return callPath; }

  private final List<GenericCallParam> genericParams = new ArrayList<GenericCallParam>();
  public AbstractComponentCallNode addGenericParam(GenericCallParam genericParam) {
    if (genericParam == null) { throw new NullPointerException(); }
    genericParams.add(genericParam);
    return this;
  }
  public List<GenericCallParam> getGenericParams() { return genericParams; }

  private final AbstractParamsNode params;
  public AbstractParamsNode getParams() { return params; }

  @Override public boolean equals(Object obj) {
    return obj != null
        && super.equals(obj)
      && callPath.equals(((AbstractComponentCallNode) obj).callPath)
      && genericParams.equals(((AbstractComponentCallNode) obj).genericParams)
      && params.equals(((AbstractComponentCallNode) obj).params)
    ;
  }

  @Override public int hashCode() {
    return super.hashCode()
      ^ callPath.hashCode()
      ^ genericParams.hashCode()
      ^ params.hashCode()
    ;
  }

  @Override protected void propertiesToString(StringBuilder buffer) {
    super.propertiesToString(buffer);
    addProperty(buffer, "callPath", callPath);
    addPropertyList(buffer, "genericParam", genericParams);
    addProperty(buffer, "params", params);
  }

}
