package org.jamon.node;

import java.util.ArrayList;
import java.util.List;

import org.jamon.api.Location;
public class AliasesNode extends AbstractNode {
  public AliasesNode(Location location) {
    super(location);
  }

  @Override public void apply(Analysis analysis)
  {
    analysis.caseAliasesNode(this);
  }

  private final List<AliasDefNode> aliass = new ArrayList<AliasDefNode>();
  public AliasesNode addAlias(AliasDefNode alias) {
    if (alias == null) { throw new NullPointerException(); }
    aliass.add(alias);
    return this;
  }
  public List<AliasDefNode> getAliass() { return aliass; }

  @Override public boolean equals(Object obj) {
    return obj != null
        && super.equals(obj)
      && aliass.equals(((AliasesNode) obj).aliass)
    ;
  }

  @Override public int hashCode() {
    return super.hashCode()
      ^ aliass.hashCode()
    ;
  }

  @Override protected void propertiesToString(StringBuilder buffer) {
    super.propertiesToString(buffer);
    addPropertyList(buffer, "alias", aliass);
  }

}
