package org.jamon.node;

import org.jamon.api.Location;
public class AnnotationNode extends AbstractNode {
  public AnnotationNode(Location location, String annotations, org.jamon.codegen.AnnotationType type) {
    super(location);
    if ((this.annotations = annotations) == null)
      { throw new NullPointerException(); }
    if ((this.type = type) == null)
      { throw new NullPointerException(); }
  }

  @Override public void apply(Analysis analysis)
  {
    analysis.caseAnnotationNode(this);
  }

  private final String annotations;
  public String getAnnotations() { return annotations; }

  private final org.jamon.codegen.AnnotationType type;
  public org.jamon.codegen.AnnotationType getType() { return type; }

  @Override public boolean equals(Object obj) {
    return obj != null
        && super.equals(obj)
      && annotations.equals(((AnnotationNode) obj).annotations)
      && type.equals(((AnnotationNode) obj).type)
    ;
  }

  @Override public int hashCode() {
    return super.hashCode()
      ^ annotations.hashCode()
      ^ type.hashCode()
    ;
  }

  @Override protected void propertiesToString(StringBuilder buffer) {
    super.propertiesToString(buffer);
    addProperty(buffer, "annotations", annotations);
    addProperty(buffer, "type", type);
  }

}
