package org.jamon.node;

import org.jamon.api.Location;
public class ArgNode extends AbstractNode {
  public ArgNode(Location location, ArgTypeNode type, ArgNameNode name) {
    super(location);
    if ((this.type = type) == null)
      { throw new NullPointerException(); }
    if ((this.name = name) == null)
      { throw new NullPointerException(); }
  }

  @Override public void apply(Analysis analysis)
  {
    analysis.caseArgNode(this);
  }

  private final ArgTypeNode type;
  public ArgTypeNode getType() { return type; }

  private final ArgNameNode name;
  public ArgNameNode getName() { return name; }

  @Override public boolean equals(Object obj) {
    return obj != null
        && super.equals(obj)
      && type.equals(((ArgNode) obj).type)
      && name.equals(((ArgNode) obj).name)
    ;
  }

  @Override public int hashCode() {
    return super.hashCode()
      ^ type.hashCode()
      ^ name.hashCode()
    ;
  }

  @Override protected void propertiesToString(StringBuilder buffer) {
    super.propertiesToString(buffer);
    addProperty(buffer, "type", type);
    addProperty(buffer, "name", name);
  }

}
