package org.jamon.node;

import org.jamon.api.Location;
public class ArgTypeNode extends AbstractNode {
  public ArgTypeNode(Location location, String type) {
    super(location);
    if ((this.type = type) == null)
      { throw new NullPointerException(); }
  }

  @Override public void apply(Analysis analysis)
  {
    analysis.caseArgTypeNode(this);
  }

  private final String type;
  public String getType() { return type; }

  @Override public boolean equals(Object obj) {
    return obj != null
        && super.equals(obj)
      && type.equals(((ArgTypeNode) obj).type)
    ;
  }

  @Override public int hashCode() {
    return super.hashCode()
      ^ type.hashCode()
    ;
  }

  @Override protected void propertiesToString(StringBuilder buffer) {
    super.propertiesToString(buffer);
    addProperty(buffer, "type", type);
  }

}
