package org.jamon.node;
@SuppressWarnings("unused")
public class DepthFirstAnalysisAdapter implements Analysis {
  public void inForNode(ForNode node) {}
  public void outForNode(ForNode node) {}
  @Override public void caseForNode(ForNode node) {
    inForNode(node);
    for (AbstractNode subNodeNode : node.getSubNodes()) {
      subNodeNode.apply(this);
    }
    outForNode(node);
  }

  public void inImportsNode(ImportsNode node) {}
  public void outImportsNode(ImportsNode node) {}
  @Override public void caseImportsNode(ImportsNode node) {
    inImportsNode(node);
    for (AbstractNode importNode : node.getImports()) {
      importNode.apply(this);
    }
    outImportsNode(node);
  }

  public void inReplaceableNode(ReplaceableNode node) {}
  public void outReplaceableNode(ReplaceableNode node) {}
  @Override public void caseReplaceableNode(ReplaceableNode node) {
    inReplaceableNode(node);
    outReplaceableNode(node);
  }

  public void inStaticImportNode(StaticImportNode node) {}
  public void outStaticImportNode(StaticImportNode node) {}
  @Override public void caseStaticImportNode(StaticImportNode node) {
    inStaticImportNode(node);
    outStaticImportNode(node);
  }

  public void inGenericsBoundNode(GenericsBoundNode node) {}
  public void outGenericsBoundNode(GenericsBoundNode node) {}
  @Override public void caseGenericsBoundNode(GenericsBoundNode node) {
    inGenericsBoundNode(node);
    outGenericsBoundNode(node);
  }

  public void inImportNode(ImportNode node) {}
  public void outImportNode(ImportNode node) {}
  @Override public void caseImportNode(ImportNode node) {
    inImportNode(node);
    outImportNode(node);
  }

  public void inDefNode(DefNode node) {}
  public void outDefNode(DefNode node) {}
  @Override public void caseDefNode(DefNode node) {
    inDefNode(node);
    for (AbstractNode subNodeNode : node.getSubNodes()) {
      subNodeNode.apply(this);
    }
    outDefNode(node);
  }

  public void inGenericsNode(GenericsNode node) {}
  public void outGenericsNode(GenericsNode node) {}
  @Override public void caseGenericsNode(GenericsNode node) {
    inGenericsNode(node);
    for (AbstractNode paramNode : node.getParams()) {
      paramNode.apply(this);
    }
    outGenericsNode(node);
  }

  public void inAbsMethodNode(AbsMethodNode node) {}
  public void outAbsMethodNode(AbsMethodNode node) {}
  @Override public void caseAbsMethodNode(AbsMethodNode node) {
    inAbsMethodNode(node);
    for (AbstractNode argsBlockNode : node.getArgsBlocks()) {
      argsBlockNode.apply(this);
    }
    outAbsMethodNode(node);
  }

  public void inAliasDefNode(AliasDefNode node) {}
  public void outAliasDefNode(AliasDefNode node) {}
  @Override public void caseAliasDefNode(AliasDefNode node) {
    inAliasDefNode(node);
    node.getPath().apply(this);
    outAliasDefNode(node);
  }

  public void inEscapeDirectiveNode(EscapeDirectiveNode node) {}
  public void outEscapeDirectiveNode(EscapeDirectiveNode node) {}
  @Override public void caseEscapeDirectiveNode(EscapeDirectiveNode node) {
    inEscapeDirectiveNode(node);
    outEscapeDirectiveNode(node);
  }

  public void inGenericsParamNode(GenericsParamNode node) {}
  public void outGenericsParamNode(GenericsParamNode node) {}
  @Override public void caseGenericsParamNode(GenericsParamNode node) {
    inGenericsParamNode(node);
    for (AbstractNode boundNode : node.getBounds()) {
      boundNode.apply(this);
    }
    outGenericsParamNode(node);
  }

  public void inElseIfNode(ElseIfNode node) {}
  public void outElseIfNode(ElseIfNode node) {}
  @Override public void caseElseIfNode(ElseIfNode node) {
    inElseIfNode(node);
    for (AbstractNode subNodeNode : node.getSubNodes()) {
      subNodeNode.apply(this);
    }
    outElseIfNode(node);
  }

  public void inElseNode(ElseNode node) {}
  public void outElseNode(ElseNode node) {}
  @Override public void caseElseNode(ElseNode node) {
    inElseNode(node);
    for (AbstractNode subNodeNode : node.getSubNodes()) {
      subNodeNode.apply(this);
    }
    outElseNode(node);
  }

  public void inAbstractCallNode(AbstractCallNode node) {}
  public void outAbstractCallNode(AbstractCallNode node) {}
  @Override public void caseAbstractCallNode(AbstractCallNode node) {
    inAbstractCallNode(node);
    outAbstractCallNode(node);
  }

  public void inImplementNode(ImplementNode node) {}
  public void outImplementNode(ImplementNode node) {}
  @Override public void caseImplementNode(ImplementNode node) {
    inImplementNode(node);
    outImplementNode(node);
  }

  public void inMultiFragmentCallNode(MultiFragmentCallNode node) {}
  public void outMultiFragmentCallNode(MultiFragmentCallNode node) {}
  @Override public void caseMultiFragmentCallNode(MultiFragmentCallNode node) {
    inMultiFragmentCallNode(node);
    node.getCallPath().apply(this);
    for (AbstractNode genericParamNode : node.getGenericParams()) {
      genericParamNode.apply(this);
    }
    node.getParams().apply(this);
    for (AbstractNode fragmentNode : node.getFragments()) {
      fragmentNode.apply(this);
    }
    outMultiFragmentCallNode(node);
  }

  public void inArgsNode(ArgsNode node) {}
  public void outArgsNode(ArgsNode node) {}
  @Override public void caseArgsNode(ArgsNode node) {
    inArgsNode(node);
    for (AbstractNode argNode : node.getArgs()) {
      argNode.apply(this);
    }
    outArgsNode(node);
  }

  public void inParentArgWithDefaultNode(ParentArgWithDefaultNode node) {}
  public void outParentArgWithDefaultNode(ParentArgWithDefaultNode node) {}
  @Override public void caseParentArgWithDefaultNode(ParentArgWithDefaultNode node) {
    inParentArgWithDefaultNode(node);
    node.getName().apply(this);
    node.getValue().apply(this);
    outParentArgWithDefaultNode(node);
  }

  public void inUnnamedFragmentNode(UnnamedFragmentNode node) {}
  public void outUnnamedFragmentNode(UnnamedFragmentNode node) {}
  @Override public void caseUnnamedFragmentNode(UnnamedFragmentNode node) {
    inUnnamedFragmentNode(node);
    for (AbstractNode subNodeNode : node.getSubNodes()) {
      subNodeNode.apply(this);
    }
    outUnnamedFragmentNode(node);
  }

  public void inDefaultEscapeNode(DefaultEscapeNode node) {}
  public void outDefaultEscapeNode(DefaultEscapeNode node) {}
  @Override public void caseDefaultEscapeNode(DefaultEscapeNode node) {
    inDefaultEscapeNode(node);
    outDefaultEscapeNode(node);
  }

  public void inExtendsNode(ExtendsNode node) {}
  public void outExtendsNode(ExtendsNode node) {}
  @Override public void caseExtendsNode(ExtendsNode node) {
    inExtendsNode(node);
    node.getPath().apply(this);
    outExtendsNode(node);
  }

  public void inNamedFragmentNode(NamedFragmentNode node) {}
  public void outNamedFragmentNode(NamedFragmentNode node) {}
  @Override public void caseNamedFragmentNode(NamedFragmentNode node) {
    inNamedFragmentNode(node);
    for (AbstractNode subNodeNode : node.getSubNodes()) {
      subNodeNode.apply(this);
    }
    outNamedFragmentNode(node);
  }

  public void inAbstractBodyNode(AbstractBodyNode node) {}
  public void outAbstractBodyNode(AbstractBodyNode node) {}
  @Override public void caseAbstractBodyNode(AbstractBodyNode node) {
    inAbstractBodyNode(node);
    for (AbstractNode subNodeNode : node.getSubNodes()) {
      subNodeNode.apply(this);
    }
    outAbstractBodyNode(node);
  }

  public void inEscapeNode(EscapeNode node) {}
  public void outEscapeNode(EscapeNode node) {}
  @Override public void caseEscapeNode(EscapeNode node) {
    inEscapeNode(node);
    outEscapeNode(node);
  }

  public void inFragmentArgsNode(FragmentArgsNode node) {}
  public void outFragmentArgsNode(FragmentArgsNode node) {}
  @Override public void caseFragmentArgsNode(FragmentArgsNode node) {
    inFragmentArgsNode(node);
    for (AbstractNode argNode : node.getArgs()) {
      argNode.apply(this);
    }
    outFragmentArgsNode(node);
  }

  public void inAbstractArgsNode(AbstractArgsNode node) {}
  public void outAbstractArgsNode(AbstractArgsNode node) {}
  @Override public void caseAbstractArgsNode(AbstractArgsNode node) {
    inAbstractArgsNode(node);
    for (AbstractNode argNode : node.getArgs()) {
      argNode.apply(this);
    }
    outAbstractArgsNode(node);
  }

  public void inChildCallNode(ChildCallNode node) {}
  public void outChildCallNode(ChildCallNode node) {}
  @Override public void caseChildCallNode(ChildCallNode node) {
    inChildCallNode(node);
    outChildCallNode(node);
  }

  public void inEmitNode(EmitNode node) {}
  public void outEmitNode(EmitNode node) {}
  @Override public void caseEmitNode(EmitNode node) {
    inEmitNode(node);
    node.getEscaping().apply(this);
    outEmitNode(node);
  }

  public void inDocNode(DocNode node) {}
  public void outDocNode(DocNode node) {}
  @Override public void caseDocNode(DocNode node) {
    inDocNode(node);
    outDocNode(node);
  }

  public void inUnnamedParamsNode(UnnamedParamsNode node) {}
  public void outUnnamedParamsNode(UnnamedParamsNode node) {}
  @Override public void caseUnnamedParamsNode(UnnamedParamsNode node) {
    inUnnamedParamsNode(node);
    for (AbstractNode valueNode : node.getValues()) {
      valueNode.apply(this);
    }
    outUnnamedParamsNode(node);
  }

  public void inNamedParamsNode(NamedParamsNode node) {}
  public void outNamedParamsNode(NamedParamsNode node) {}
  @Override public void caseNamedParamsNode(NamedParamsNode node) {
    inNamedParamsNode(node);
    for (AbstractNode paramNode : node.getParams()) {
      paramNode.apply(this);
    }
    outNamedParamsNode(node);
  }

  public void inSubcomponentNode(SubcomponentNode node) {}
  public void outSubcomponentNode(SubcomponentNode node) {}
  @Override public void caseSubcomponentNode(SubcomponentNode node) {
    inSubcomponentNode(node);
    for (AbstractNode subNodeNode : node.getSubNodes()) {
      subNodeNode.apply(this);
    }
    outSubcomponentNode(node);
  }

  public void inAliasesNode(AliasesNode node) {}
  public void outAliasesNode(AliasesNode node) {}
  @Override public void caseAliasesNode(AliasesNode node) {
    inAliasesNode(node);
    for (AbstractNode aliasNode : node.getAliass()) {
      aliasNode.apply(this);
    }
    outAliasesNode(node);
  }

  public void inAbstractParamsNode(AbstractParamsNode node) {}
  public void outAbstractParamsNode(AbstractParamsNode node) {}
  @Override public void caseAbstractParamsNode(AbstractParamsNode node) {
    inAbstractParamsNode(node);
    outAbstractParamsNode(node);
  }

  public void inSimpleCallNode(SimpleCallNode node) {}
  public void outSimpleCallNode(SimpleCallNode node) {}
  @Override public void caseSimpleCallNode(SimpleCallNode node) {
    inSimpleCallNode(node);
    node.getCallPath().apply(this);
    for (AbstractNode genericParamNode : node.getGenericParams()) {
      genericParamNode.apply(this);
    }
    node.getParams().apply(this);
    outSimpleCallNode(node);
  }

  public void inParentArgsNode(ParentArgsNode node) {}
  public void outParentArgsNode(ParentArgsNode node) {}
  @Override public void caseParentArgsNode(ParentArgsNode node) {
    inParentArgsNode(node);
    for (AbstractNode argNode : node.getArgs()) {
      argNode.apply(this);
    }
    outParentArgsNode(node);
  }

  public void inTopNode(TopNode node) {}
  public void outTopNode(TopNode node) {}
  @Override public void caseTopNode(TopNode node) {
    inTopNode(node);
    for (AbstractNode subNodeNode : node.getSubNodes()) {
      subNodeNode.apply(this);
    }
    outTopNode(node);
  }

  public void inOverrideNode(OverrideNode node) {}
  public void outOverrideNode(OverrideNode node) {}
  @Override public void caseOverrideNode(OverrideNode node) {
    inOverrideNode(node);
    for (AbstractNode subNodeNode : node.getSubNodes()) {
      subNodeNode.apply(this);
    }
    outOverrideNode(node);
  }

  public void inReplacesNode(ReplacesNode node) {}
  public void outReplacesNode(ReplacesNode node) {}
  @Override public void caseReplacesNode(ReplacesNode node) {
    inReplacesNode(node);
    node.getPath().apply(this);
    outReplacesNode(node);
  }

  public void inAbstractEscapeNode(AbstractEscapeNode node) {}
  public void outAbstractEscapeNode(AbstractEscapeNode node) {}
  @Override public void caseAbstractEscapeNode(AbstractEscapeNode node) {
    inAbstractEscapeNode(node);
    outAbstractEscapeNode(node);
  }

  public void inArgNode(ArgNode node) {}
  public void outArgNode(ArgNode node) {}
  @Override public void caseArgNode(ArgNode node) {
    inArgNode(node);
    node.getType().apply(this);
    node.getName().apply(this);
    outArgNode(node);
  }

  public void inAbstractPathNode(AbstractPathNode node) {}
  public void outAbstractPathNode(AbstractPathNode node) {}
  @Override public void caseAbstractPathNode(AbstractPathNode node) {
    inAbstractPathNode(node);
    for (AbstractNode pathElementNode : node.getPathElements()) {
      pathElementNode.apply(this);
    }
    outAbstractPathNode(node);
  }

  public void inJavaNode(JavaNode node) {}
  public void outJavaNode(JavaNode node) {}
  @Override public void caseJavaNode(JavaNode node) {
    inJavaNode(node);
    outJavaNode(node);
  }

  public void inArgTypeNode(ArgTypeNode node) {}
  public void outArgTypeNode(ArgTypeNode node) {}
  @Override public void caseArgTypeNode(ArgTypeNode node) {
    inArgTypeNode(node);
    outArgTypeNode(node);
  }

  public void inAbsolutePathNode(AbsolutePathNode node) {}
  public void outAbsolutePathNode(AbsolutePathNode node) {}
  @Override public void caseAbsolutePathNode(AbsolutePathNode node) {
    inAbsolutePathNode(node);
    for (AbstractNode pathElementNode : node.getPathElements()) {
      pathElementNode.apply(this);
    }
    outAbsolutePathNode(node);
  }

  public void inAbstractImportNode(AbstractImportNode node) {}
  public void outAbstractImportNode(AbstractImportNode node) {}
  @Override public void caseAbstractImportNode(AbstractImportNode node) {
    inAbstractImportNode(node);
    outAbstractImportNode(node);
  }

  public void inAnnotationNode(AnnotationNode node) {}
  public void outAnnotationNode(AnnotationNode node) {}
  @Override public void caseAnnotationNode(AnnotationNode node) {
    inAnnotationNode(node);
    outAnnotationNode(node);
  }

  public void inParamValueNode(ParamValueNode node) {}
  public void outParamValueNode(ParamValueNode node) {}
  @Override public void caseParamValueNode(ParamValueNode node) {
    inParamValueNode(node);
    outParamValueNode(node);
  }

  public void inFragmentCallNode(FragmentCallNode node) {}
  public void outFragmentCallNode(FragmentCallNode node) {}
  @Override public void caseFragmentCallNode(FragmentCallNode node) {
    inFragmentCallNode(node);
    node.getCallPath().apply(this);
    for (AbstractNode genericParamNode : node.getGenericParams()) {
      genericParamNode.apply(this);
    }
    node.getParams().apply(this);
    node.getFragment().apply(this);
    outFragmentCallNode(node);
  }

  public void inNoParamsNode(NoParamsNode node) {}
  public void outNoParamsNode(NoParamsNode node) {}
  @Override public void caseNoParamsNode(NoParamsNode node) {
    inNoParamsNode(node);
    outNoParamsNode(node);
  }

  public void inArgValueNode(ArgValueNode node) {}
  public void outArgValueNode(ArgValueNode node) {}
  @Override public void caseArgValueNode(ArgValueNode node) {
    inArgValueNode(node);
    outArgValueNode(node);
  }

  public void inPathElementNode(PathElementNode node) {}
  public void outPathElementNode(PathElementNode node) {}
  @Override public void casePathElementNode(PathElementNode node) {
    inPathElementNode(node);
    outPathElementNode(node);
  }

  public void inParentArgNode(ParentArgNode node) {}
  public void outParentArgNode(ParentArgNode node) {}
  @Override public void caseParentArgNode(ParentArgNode node) {
    inParentArgNode(node);
    node.getName().apply(this);
    outParentArgNode(node);
  }

  public void inParentMarkerNode(ParentMarkerNode node) {}
  public void outParentMarkerNode(ParentMarkerNode node) {}
  @Override public void caseParentMarkerNode(ParentMarkerNode node) {
    inParentMarkerNode(node);
    outParentMarkerNode(node);
  }

  public void inMethodNode(MethodNode node) {}
  public void outMethodNode(MethodNode node) {}
  @Override public void caseMethodNode(MethodNode node) {
    inMethodNode(node);
    for (AbstractNode subNodeNode : node.getSubNodes()) {
      subNodeNode.apply(this);
    }
    outMethodNode(node);
  }

  public void inUpdirNode(UpdirNode node) {}
  public void outUpdirNode(UpdirNode node) {}
  @Override public void caseUpdirNode(UpdirNode node) {
    inUpdirNode(node);
    outUpdirNode(node);
  }

  public void inNamedAliasPathNode(NamedAliasPathNode node) {}
  public void outNamedAliasPathNode(NamedAliasPathNode node) {}
  @Override public void caseNamedAliasPathNode(NamedAliasPathNode node) {
    inNamedAliasPathNode(node);
    for (AbstractNode pathElementNode : node.getPathElements()) {
      pathElementNode.apply(this);
    }
    outNamedAliasPathNode(node);
  }

  public void inClassNode(ClassNode node) {}
  public void outClassNode(ClassNode node) {}
  @Override public void caseClassNode(ClassNode node) {
    inClassNode(node);
    outClassNode(node);
  }

  public void inArgNameNode(ArgNameNode node) {}
  public void outArgNameNode(ArgNameNode node) {}
  @Override public void caseArgNameNode(ArgNameNode node) {
    inArgNameNode(node);
    outArgNameNode(node);
  }

  public void inRelativePathNode(RelativePathNode node) {}
  public void outRelativePathNode(RelativePathNode node) {}
  @Override public void caseRelativePathNode(RelativePathNode node) {
    inRelativePathNode(node);
    for (AbstractNode pathElementNode : node.getPathElements()) {
      pathElementNode.apply(this);
    }
    outRelativePathNode(node);
  }

  public void inAbstractPathElementNode(AbstractPathElementNode node) {}
  public void outAbstractPathElementNode(AbstractPathElementNode node) {}
  @Override public void caseAbstractPathElementNode(AbstractPathElementNode node) {
    inAbstractPathElementNode(node);
    outAbstractPathElementNode(node);
  }

  public void inRootAliasPathNode(RootAliasPathNode node) {}
  public void outRootAliasPathNode(RootAliasPathNode node) {}
  @Override public void caseRootAliasPathNode(RootAliasPathNode node) {
    inRootAliasPathNode(node);
    for (AbstractNode pathElementNode : node.getPathElements()) {
      pathElementNode.apply(this);
    }
    outRootAliasPathNode(node);
  }

  public void inAbstractComponentCallNode(AbstractComponentCallNode node) {}
  public void outAbstractComponentCallNode(AbstractComponentCallNode node) {}
  @Override public void caseAbstractComponentCallNode(AbstractComponentCallNode node) {
    inAbstractComponentCallNode(node);
    node.getCallPath().apply(this);
    for (AbstractNode genericParamNode : node.getGenericParams()) {
      genericParamNode.apply(this);
    }
    node.getParams().apply(this);
    outAbstractComponentCallNode(node);
  }

  public void inImplementsNode(ImplementsNode node) {}
  public void outImplementsNode(ImplementsNode node) {}
  @Override public void caseImplementsNode(ImplementsNode node) {
    inImplementsNode(node);
    for (AbstractNode implementNode : node.getImplements()) {
      implementNode.apply(this);
    }
    outImplementsNode(node);
  }

  public void inIfNode(IfNode node) {}
  public void outIfNode(IfNode node) {}
  @Override public void caseIfNode(IfNode node) {
    inIfNode(node);
    for (AbstractNode subNodeNode : node.getSubNodes()) {
      subNodeNode.apply(this);
    }
    outIfNode(node);
  }

  public void inParamNameNode(ParamNameNode node) {}
  public void outParamNameNode(ParamNameNode node) {}
  @Override public void caseParamNameNode(ParamNameNode node) {
    inParamNameNode(node);
    outParamNameNode(node);
  }

  public void inGenericCallParam(GenericCallParam node) {}
  public void outGenericCallParam(GenericCallParam node) {}
  @Override public void caseGenericCallParam(GenericCallParam node) {
    inGenericCallParam(node);
    outGenericCallParam(node);
  }

  public void inLiteralNode(LiteralNode node) {}
  public void outLiteralNode(LiteralNode node) {}
  @Override public void caseLiteralNode(LiteralNode node) {
    inLiteralNode(node);
    outLiteralNode(node);
  }

  public void inTextNode(TextNode node) {}
  public void outTextNode(TextNode node) {}
  @Override public void caseTextNode(TextNode node) {
    inTextNode(node);
    outTextNode(node);
  }

  public void inWhileNode(WhileNode node) {}
  public void outWhileNode(WhileNode node) {}
  @Override public void caseWhileNode(WhileNode node) {
    inWhileNode(node);
    for (AbstractNode subNodeNode : node.getSubNodes()) {
      subNodeNode.apply(this);
    }
    outWhileNode(node);
  }

  public void inOptionalArgNode(OptionalArgNode node) {}
  public void outOptionalArgNode(OptionalArgNode node) {}
  @Override public void caseOptionalArgNode(OptionalArgNode node) {
    inOptionalArgNode(node);
    node.getType().apply(this);
    node.getName().apply(this);
    node.getValue().apply(this);
    outOptionalArgNode(node);
  }

  public void inNamedParamNode(NamedParamNode node) {}
  public void outNamedParamNode(NamedParamNode node) {}
  @Override public void caseNamedParamNode(NamedParamNode node) {
    inNamedParamNode(node);
    node.getName().apply(this);
    node.getValue().apply(this);
    outNamedParamNode(node);
  }

}
