package org.jamon.node;

import org.jamon.api.Location;
public class EmitNode extends AbstractNode {
  public EmitNode(Location location, String emitExpression, AbstractEscapeNode escaping) {
    super(location);
    if ((this.emitExpression = emitExpression) == null)
      { throw new NullPointerException(); }
    if ((this.escaping = escaping) == null)
      { throw new NullPointerException(); }
  }

  @Override public void apply(Analysis analysis)
  {
    analysis.caseEmitNode(this);
  }

  private final String emitExpression;
  public String getEmitExpression() { return emitExpression; }

  private final AbstractEscapeNode escaping;
  public AbstractEscapeNode getEscaping() { return escaping; }

  @Override public boolean equals(Object obj) {
    return obj != null
        && super.equals(obj)
      && emitExpression.equals(((EmitNode) obj).emitExpression)
      && escaping.equals(((EmitNode) obj).escaping)
    ;
  }

  @Override public int hashCode() {
    return super.hashCode()
      ^ emitExpression.hashCode()
      ^ escaping.hashCode()
    ;
  }

  @Override protected void propertiesToString(StringBuilder buffer) {
    super.propertiesToString(buffer);
    addProperty(buffer, "emitExpression", emitExpression);
    addProperty(buffer, "escaping", escaping);
  }

}
