package org.jamon.node;

import org.jamon.api.Location;
public class GenericCallParam extends AbstractNode {
  public GenericCallParam(Location location, String className) {
    super(location);
    if ((this.className = className) == null)
      { throw new NullPointerException(); }
  }

  @Override public void apply(Analysis analysis)
  {
    analysis.caseGenericCallParam(this);
  }

  private final String className;
  public String getClassName() { return className; }

  @Override public boolean equals(Object obj) {
    return obj != null
        && super.equals(obj)
      && className.equals(((GenericCallParam) obj).className)
    ;
  }

  @Override public int hashCode() {
    return super.hashCode()
      ^ className.hashCode()
    ;
  }

  @Override protected void propertiesToString(StringBuilder buffer) {
    super.propertiesToString(buffer);
    addProperty(buffer, "className", className);
  }

}
