package org.jamon.node;

import java.util.ArrayList;
import java.util.List;

import org.jamon.api.Location;
public class GenericsNode extends AbstractNode {
  public GenericsNode(Location location) {
    super(location);
  }

  @Override public void apply(Analysis analysis)
  {
    analysis.caseGenericsNode(this);
  }

  private final List<GenericsParamNode> params = new ArrayList<GenericsParamNode>();
  public GenericsNode addParam(GenericsParamNode param) {
    if (param == null) { throw new NullPointerException(); }
    params.add(param);
    return this;
  }
  public List<GenericsParamNode> getParams() { return params; }

  @Override public boolean equals(Object obj) {
    return obj != null
        && super.equals(obj)
      && params.equals(((GenericsNode) obj).params)
    ;
  }

  @Override public int hashCode() {
    return super.hashCode()
      ^ params.hashCode()
    ;
  }

  @Override protected void propertiesToString(StringBuilder buffer) {
    super.propertiesToString(buffer);
    addPropertyList(buffer, "param", params);
  }

}
