package org.jamon.node;

import java.util.ArrayList;
import java.util.List;

import org.jamon.api.Location;
public class ImportsNode extends AbstractNode {
  public ImportsNode(Location location) {
    super(location);
  }

  @Override public void apply(Analysis analysis)
  {
    analysis.caseImportsNode(this);
  }

  private final List<AbstractImportNode> imports = new ArrayList<AbstractImportNode>();
  public ImportsNode addImport(AbstractImportNode _import) {
    if (_import == null) { throw new NullPointerException(); }
    imports.add(_import);
    return this;
  }
  public List<AbstractImportNode> getImports() { return imports; }

  @Override public boolean equals(Object obj) {
    return obj != null
        && super.equals(obj)
      && imports.equals(((ImportsNode) obj).imports)
    ;
  }

  @Override public int hashCode() {
    return super.hashCode()
      ^ imports.hashCode()
    ;
  }

  @Override protected void propertiesToString(StringBuilder buffer) {
    super.propertiesToString(buffer);
    addPropertyList(buffer, "import", imports);
  }

}
