package org.jamon.node;

import org.jamon.api.Location;
public class JavaNode extends AbstractNode {
  public JavaNode(Location location, String java) {
    super(location);
    if ((this.java = java) == null)
      { throw new NullPointerException(); }
  }

  @Override public void apply(Analysis analysis)
  {
    analysis.caseJavaNode(this);
  }

  private final String java;
  public String getJava() { return java; }

  @Override public boolean equals(Object obj) {
    return obj != null
        && super.equals(obj)
      && java.equals(((JavaNode) obj).java)
    ;
  }

  @Override public int hashCode() {
    return super.hashCode()
      ^ java.hashCode()
    ;
  }

  @Override protected void propertiesToString(StringBuilder buffer) {
    super.propertiesToString(buffer);
    addProperty(buffer, "java", java);
  }

}
