package org.jamon.node;

import org.jamon.api.Location;
public class ParentArgNode extends AbstractNode {
  public ParentArgNode(Location location, ArgNameNode name) {
    super(location);
    if ((this.name = name) == null)
      { throw new NullPointerException(); }
  }

  @Override public void apply(Analysis analysis)
  {
    analysis.caseParentArgNode(this);
  }

  private final ArgNameNode name;
  public ArgNameNode getName() { return name; }

  @Override public boolean equals(Object obj) {
    return obj != null
        && super.equals(obj)
      && name.equals(((ParentArgNode) obj).name)
    ;
  }

  @Override public int hashCode() {
    return super.hashCode()
      ^ name.hashCode()
    ;
  }

  @Override protected void propertiesToString(StringBuilder buffer) {
    super.propertiesToString(buffer);
    addProperty(buffer, "name", name);
  }

}
