package org.jamon.node;

import java.util.ArrayList;
import java.util.List;

import org.jamon.api.Location;
public class ParentArgsNode extends AbstractNode {
  public ParentArgsNode(Location location) {
    super(location);
  }

  @Override public void apply(Analysis analysis)
  {
    analysis.caseParentArgsNode(this);
  }

  private final List<ParentArgNode> args = new ArrayList<ParentArgNode>();
  public ParentArgsNode addArg(ParentArgNode arg) {
    if (arg == null) { throw new NullPointerException(); }
    args.add(arg);
    return this;
  }
  public List<ParentArgNode> getArgs() { return args; }

  @Override public boolean equals(Object obj) {
    return obj != null
        && super.equals(obj)
      && args.equals(((ParentArgsNode) obj).args)
    ;
  }

  @Override public int hashCode() {
    return super.hashCode()
      ^ args.hashCode()
    ;
  }

  @Override protected void propertiesToString(StringBuilder buffer) {
    super.propertiesToString(buffer);
    addPropertyList(buffer, "arg", args);
  }

}
