package org.jamon.node;

import org.jamon.api.Location;
public class PathElementNode extends AbstractPathElementNode {
  public PathElementNode(Location location, String name) {
    super(location);
    if ((this.name = name) == null)
      { throw new NullPointerException(); }
  }

  @Override public void apply(Analysis analysis)
  {
    analysis.casePathElementNode(this);
  }

  private final String name;
  public String getName() { return name; }

  @Override public boolean equals(Object obj) {
    return obj != null
        && super.equals(obj)
      && name.equals(((PathElementNode) obj).name)
    ;
  }

  @Override public int hashCode() {
    return super.hashCode()
      ^ name.hashCode()
    ;
  }

  @Override protected void propertiesToString(StringBuilder buffer) {
    super.propertiesToString(buffer);
    addProperty(buffer, "name", name);
  }

}
