package org.jamon.node;

import java.util.ArrayList;
import java.util.List;

import org.jamon.api.Location;
public class UnnamedParamsNode extends AbstractParamsNode {
  public UnnamedParamsNode(Location location) {
    super(location);
  }

  @Override public void apply(Analysis analysis)
  {
    analysis.caseUnnamedParamsNode(this);
  }

  private final List<ParamValueNode> values = new ArrayList<ParamValueNode>();
  public UnnamedParamsNode addValue(ParamValueNode value) {
    if (value == null) { throw new NullPointerException(); }
    values.add(value);
    return this;
  }
  public List<ParamValueNode> getValues() { return values; }

  @Override public boolean equals(Object obj) {
    return obj != null
        && super.equals(obj)
      && values.equals(((UnnamedParamsNode) obj).values)
    ;
  }

  @Override public int hashCode() {
    return super.hashCode()
      ^ values.hashCode()
    ;
  }

  @Override protected void propertiesToString(StringBuilder buffer) {
    super.propertiesToString(buffer);
    addPropertyList(buffer, "value", values);
  }

}
