/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import org.jamon.api.Location;
import org.jamon.codegen.CodeWriter;
import org.jamon.node.ArgNode;
import org.jamon.util.StringUtils;

public abstract class AbstractArgument
implements Comparable<AbstractArgument> {
    private final String name;
    private final String type;
    private final Location location;

    public AbstractArgument(String name, String type, Location location) {
        this.name = name;
        this.type = type;
        this.location = location;
    }

    public AbstractArgument(ArgNode arg) {
        this(arg.getName().getName(), arg.getType().getType(), arg.getLocation());
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getFullyQualifiedType() {
        return this.getType();
    }

    public Location getLocation() {
        return this.location;
    }

    public String getSetterName() {
        return "set" + StringUtils.capitalize(this.getName());
    }

    public String getGetterName() {
        return "get" + StringUtils.capitalize(this.getName());
    }

    public void generateImplDataCode(CodeWriter writer) {
        writer.printLocation(this.getLocation());
        writer.println("public void " + this.getSetterName() + "(" + this.getFullyQualifiedType() + " " + this.getName() + ")");
        writer.openBlock();
        this.generateImplDataSetterCode(writer);
        writer.closeBlock();
        writer.println("public " + this.getFullyQualifiedType() + " " + this.getGetterName() + "()");
        writer.openBlock();
        writer.println("return m_" + this.getName() + ";");
        writer.closeBlock();
        writer.println("private " + this.getFullyQualifiedType() + " m_" + this.getName() + ";");
    }

    @Override
    public int compareTo(AbstractArgument other) {
        int result = this.name.compareTo(other.name);
        if (result == 0) {
            result = this.type.compareTo(other.type);
        }
        return result;
    }

    protected void generateImplDataSetterCode(CodeWriter writer) {
        writer.printLocation(this.getLocation());
        writer.println("m_" + this.getName() + " = " + this.getName() + ";");
    }
}

