/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import java.io.IOException;
import java.util.List;
import org.jamon.api.Location;
import org.jamon.codegen.AbstractCallStatement;
import org.jamon.codegen.CodeWriter;
import org.jamon.codegen.FragmentUnit;
import org.jamon.codegen.OptionalArgument;
import org.jamon.codegen.ParamValues;
import org.jamon.codegen.PathUtils;
import org.jamon.codegen.TemplateDescriber;
import org.jamon.codegen.TemplateDescription;
import org.jamon.compiler.ParserErrorImpl;
import org.jamon.node.GenericCallParam;

public class ComponentCallStatement
extends AbstractCallStatement {
    private static int uniqueId = 0;
    private final List<GenericCallParam> genericParams;
    private final String callingTemplateJamonContextType;

    ComponentCallStatement(String path, ParamValues params, Location location, String templateIdentifier, List<GenericCallParam> genericParams, String callingTemplateJamonContextType) {
        super(path, params, location, templateIdentifier);
        this.genericParams = genericParams;
        this.callingTemplateJamonContextType = callingTemplateJamonContextType;
    }

    @Override
    protected String getFragmentIntfName(FragmentUnit fragmentUnitIntf) {
        return this.getComponentProxyClassName() + "." + fragmentUnitIntf.getFragmentInterfaceName(false) + this.getGenericParams();
    }

    @Override
    public void generateSource(CodeWriter writer, TemplateDescriber describer) throws ParserErrorImpl {
        TemplateDescription desc;
        this.generateSourceLine(writer);
        writer.openBlock();
        try {
            desc = describer.getTemplateDescription(this.getPath(), this.getLocation());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (desc.getJamonContextType() != null && this.callingTemplateJamonContextType == null) {
            throw new ParserErrorImpl(this.getLocation(), "Calling component does not have a jamonContext, but called component " + this.getPath() + " expects one of type " + desc.getJamonContextType());
        }
        if (this.hasGenericParams() && desc.getGenericParamsCount() != this.getGenericParamCount()) {
            throw new ParserErrorImpl(this.getLocation(), "Call to component " + this.getPath() + " provides " + this.getGenericParamCount() + " generic params, but " + this.getPath() + " only expects " + desc.getGenericParamsCount());
        }
        this.makeFragmentImplClasses(desc.getFragmentInterfaces(), writer, describer);
        String instanceVar = ComponentCallStatement.getUniqueName();
        writer.println(this.getComponentProxyClassName() + this.getGenericParams() + " " + instanceVar + " = new " + this.getComponentProxyClassName() + this.getGenericParams() + "(this.getTemplateManager());");
        if (desc.getJamonContextType() != null) {
            writer.println(instanceVar + ".setJamonContext(jamonContext);");
        }
        for (OptionalArgument arg : desc.getOptionalArgs()) {
            String value = this.getParams().getOptionalArgValue(arg.getName());
            if (value == null) continue;
            writer.println(instanceVar + "." + arg.getSetterName() + "(" + value + ");");
        }
        writer.print(instanceVar + ".renderNoFlush");
        writer.openList();
        writer.printListElement("jamonWriter");
        this.getParams().generateRequiredArgs(desc.getRequiredArgs(), writer);
        this.generateFragmentParams(writer, desc.getFragmentInterfaces());
        writer.closeList();
        writer.println(";");
        this.checkSuppliedParams();
        writer.closeBlock();
    }

    protected boolean hasGenericParams() {
        return !this.genericParams.isEmpty();
    }

    protected int getGenericParamCount() {
        return this.genericParams.size();
    }

    protected String getGenericParams() {
        if (this.hasGenericParams()) {
            StringBuilder builder = new StringBuilder();
            builder.append('<');
            boolean paramsAdded = false;
            for (GenericCallParam param : this.genericParams) {
                if (paramsAdded) {
                    builder.append(", ");
                }
                builder.append(param.getClassName());
                paramsAdded = true;
            }
            builder.append('>');
            return builder.toString();
        }
        return "";
    }

    private String getComponentProxyClassName() {
        return PathUtils.getFullyQualifiedIntfClassName(this.getPath());
    }

    private static String getUniqueName() {
        return "__jamon__var_" + uniqueId++;
    }
}

