/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class EncodingReader
extends Reader {
    private final Reader reader;
    private String encoding;
    private int bytesRead;
    private static final byte[] ONEBYTESIG;
    private static final byte[] UTF16LESIG;
    private static final byte[] UTF16BESIG;
    private static final int SPACE = 32;
    private static final int TAB = 9;
    private static final int CLOSE = 62;
    private static final int INNAME = 1;
    private static final int WAITFORCLOSE = 2;
    private static final int CLOSED = 3;

    public EncodingReader(InputStream stream) throws IOException {
        PushbackInputStream pushbackStream = new PushbackInputStream(stream, 50);
        this.encoding = this.matches(ONEBYTESIG, pushbackStream) ? this.computeOneByteEncoding(pushbackStream) : (this.matches(UTF16LESIG, pushbackStream) || this.matches(UTF16BESIG, pushbackStream) ? this.computeUtf16Encoding(pushbackStream) : Charset.defaultCharset().name());
        this.reader = new InputStreamReader((InputStream)pushbackStream, this.encoding);
    }

    public String getEncoding() {
        return this.encoding;
    }

    private boolean matches(byte[] match, PushbackInputStream stream) throws IOException {
        byte[] data = new byte[match.length];
        int len = stream.read(data);
        if (len == -1) {
            return false;
        }
        if (len == match.length) {
            for (int i = 0; i < len; ++i) {
                if (match[i] == data[i]) continue;
                stream.unread(data, 0, len);
                return false;
            }
            this.bytesRead = len;
            return true;
        }
        stream.unread(data, 0, len);
        return false;
    }

    private String computeUtf16Encoding(PushbackInputStream stream) throws IOException {
        return this.computeEncoding(stream, true);
    }

    private String computeOneByteEncoding(PushbackInputStream stream) throws IOException {
        return this.computeEncoding(stream, false);
    }

    private String computeEncoding(PushbackInputStream stream, boolean twoBytes) throws IOException {
        StringBuilder encoding;
        block9: {
            encoding = new StringBuilder();
            boolean lowByte = true;
            int state = 0;
            while (true) {
                int c = stream.read();
                ++this.bytesRead;
                if (twoBytes) {
                    if (lowByte) {
                        if (c != 0) {
                            throw new Exception("Malformed encoding name", this.bytesRead / (twoBytes ? 2 : 1));
                        }
                        lowByte = false;
                        continue;
                    }
                    lowByte = true;
                }
                if (c == -1) {
                    throw new Exception("EOF before encoding tag finished", this.bytesRead / (twoBytes ? 2 : 1));
                }
                if (c == 32 || c == 9) {
                    if (state != true) continue;
                    state = 2;
                    continue;
                }
                if (c == 62) {
                    state = 3;
                    continue;
                }
                if (state == 3) {
                    if (c == 13 || c == 10) continue;
                    stream.unread(c);
                    if (twoBytes) {
                        stream.unread(0);
                    }
                    break block9;
                }
                if (state == 2) break;
                state = 1;
                encoding.append((char)c);
            }
            throw new Exception("Malformed encoding tag; expected '>'", this.bytesRead / (twoBytes ? 2 : 1));
        }
        return encoding.toString();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public int read(char[] buf, int offset, int len) throws IOException {
        return this.reader.read(buf, offset, len);
    }

    static {
        try {
            ONEBYTESIG = "<%encoding ".getBytes("latin1");
            UTF16BESIG = "<%encoding ".getBytes("UTF-16BE");
            UTF16LESIG = "<%encoding ".getBytes("UTF-16LE");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static class Exception
    extends IOException {
        private static final long serialVersionUID = 2006091701L;
        private final int pos;

        public Exception(String message, int pos) {
            super(message);
            this.pos = pos;
        }

        public int getPos() {
            return this.pos;
        }
    }
}

