/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import java.util.HashMap;
import java.util.Map;
import org.jamon.escaping.Escaping;

public class EscapingDirective {
    public static final String DEFAULT_ESCAPE_CODE = "h";
    private final String java;
    private static final Map<String, EscapingDirective> standardDirectives = new HashMap<String, EscapingDirective>();
    private static final String PREFIX = Escaping.class.getName() + ".";

    public String toJava() {
        return this.java;
    }

    public static EscapingDirective get(String abbreviation) {
        return standardDirectives.get(abbreviation);
    }

    private EscapingDirective(String java) {
        this.java = PREFIX + java;
    }

    static {
        standardDirectives.put("H", new EscapingDirective("STRICT_HTML"));
        standardDirectives.put(DEFAULT_ESCAPE_CODE, new EscapingDirective("HTML"));
        standardDirectives.put("n", new EscapingDirective("NONE"));
        standardDirectives.put("u", new EscapingDirective("URL"));
        standardDirectives.put("x", new EscapingDirective("XML"));
        standardDirectives.put("j", new EscapingDirective("JAVASCRIPT"));
    }
}

